package com.biz.crm.promotion.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateVo;
import com.biz.crm.promotion.service.PromotionPolicyTemplateService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;


/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:50
 *  @version: V1.0
 *  @Description:
 */
@Api(value = "管理端-促销政策模板", tags = "管理端-促销政策模板")
@RestController
@RequestMapping("/promotion/template")
public class PromotionPolicyTemplateController {

    @Resource
    private PromotionPolicyTemplateService promotionPolicyTemplateService;


    @CrmLog
    @ApiOperation(value = "新增、修改模板")
    @PostMapping
    public Result addOrUpdate(@RequestBody PromotionPolicyTemplateEditVo vo) {
        promotionPolicyTemplateService.addOrUpdate(vo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value = "加载模板编辑页面数据")
    @GetMapping("editinfo")
    public Result<PromotionPolicyTemplateEditVo> loadTemplateEditVo(@RequestParam(value = "templateId", required = false)String templateId
            , @RequestParam(value = "promotionType", required = false) String promotionType) {
        return Result.ok(promotionPolicyTemplateService.loadTemplateEditVo(templateId, promotionType));
    }
    @CrmLog
    @ApiOperation(value = "加载模板信息-政策编辑场景")
    @GetMapping("loadtemplateinfo")
    public Result<PromotionPolicyTemplateEditVo> loadTemplateInfo(@RequestParam("templateId") String templateId) {
        return Result.ok(promotionPolicyTemplateService.loadTemplateInfo(templateId));
    }
    @CrmLog
    @ApiOperation(value = "分页搜索")
    @CrmDictMethod
    @PostMapping(value = "page")
    public Result<PageResult<PromotionPolicyTemplateVo>> getPageList(@RequestBody PromotionPolicyTemplateQueryVo vo) {
        return Result.ok(promotionPolicyTemplateService.getPageList(vo));
    }

    @CrmLog
    @ApiOperation(value = "删除")
    @PostMapping("del")
    public Result del(@RequestBody List<String> templateIds) {
        promotionPolicyTemplateService.del(templateIds);
        return Result.ok();
    }
    @CrmLog
    @ApiOperation(value = "禁用")
    @PostMapping(value = "disable")
    public Result disable(@RequestBody List<String> templateIds) {
        promotionPolicyTemplateService.disable(templateIds);
        return Result.ok();
    }
    @CrmLog
    @ApiOperation(value = "启用")
    @PostMapping(value = "enable")
    public Result enable(@RequestBody List<String> templateIds) {
        promotionPolicyTemplateService.enable(templateIds);
        return Result.ok();
    }
}
