package com.biz.crm.promotion.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import javax.persistence.Index;
import java.math.BigDecimal;

/**
 * 促销政策订单明细实体类
 *
 * @author lf
 * @date 2020-12-26 13:34:30
 */
@Getter
@Setter
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@TableName("dms_pro_policy_order_detail")
@CrmTable(name = "dms_pro_policy_order_detail", indexes = {
        @Index(name = "index_policy_order_detail_status", columnList = "policy_order_detail_status"),
        @Index(name = "index_promotion_policy_id", columnList = "promotion_policy_id"),
        @Index(name = "index_order_id", columnList = "order_id"),
        @Index(name = "index_order_no", columnList = "order_no")
},tableNote = "促销政策订单明细实体类")
public class DmsPromotionPolicyOrderDetailEntity extends CrmExtTenEntity<DmsPromotionPolicyOrderDetailEntity> {

    /**
     * 明细状态 locked:已锁定, commit:已提交, unlock:解除锁定, rollback:已回滚
     */
    @CrmColumn(name = "policy_order_detail_status")
    private String policyOrderDetailStatus;

    /**
     * 促销政策id
     */
    @CrmColumn(name = "promotion_policy_id", length = 64)
    private String promotionPolicyId;

    @CrmColumn(name = "promotion_code", length = 64)
    private String promotionCode;

    /**
     * 订单id
     */
    @CrmColumn(name = "order_id", length = 64)
    private String orderId;

    /**
     * 订单号
     */
    @CrmColumn(name = "order_no", length = 100)
    private String orderNo;

    /**
     * 客户编码
     */
    @CrmColumn(name = "customer_code", length = 64)
    private String customerCode;

    /**
     * 客户名称
     */
    @CrmColumn(name = "customer_name", length = 100)
    private String customerName;

    /**
     * 政策使用量
     */
    @CrmColumn(name = "used_qty")
    private BigDecimal usedQty;

    /**
     * 政策使用量类型 QTY_TYPE number:数量, amount:金额
     */
    @CrmColumn(name = "used_qty_type", length = 64)
    private String usedQtyType;

    /**
     * 政策使用量单位 rmb:元, product_base_unit:基本单位, material_sale_unit:销售单位
     */
    @CrmColumn(name = "used_qty_unit", length = 100)
    private String usedQtyUnit;

    /**
     * 命中该政策的明细数据
     */
    @CrmColumn(name = "hit_detail")
    private String hitDetail;

}
