package com.biz.crm.promotion.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;


/**
 * 促销商品
 *
 * @author: luoqi
 * @Date: 2020-10-15 14:56
 * @version: V1.0
 * @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_promotion_policy_product")
@CrmTable(name = "dms_promotion_policy_product", tableNote = "促销商品")
public class PromotionPolicyProductEntity extends CrmExtEntity<PromotionPolicyProductEntity> {

    /**
     * 商品编码
     */
    @CrmColumn(name = "product_code", length = 64)
    private String productCode;


    /**
     * 商品名称
     */
    @CrmColumn(name = "product_name", length = 64)
    private String productName;

    /**
     * 本品赠品一一对应-赠品编码
     */
    @CrmColumn(name = "product_code_gift", length = 64)
    private String productCodeGift;


    /**
     * 本品赠品一一对应-赠品名称
     */
    @CrmColumn(name = "product_name_gift", length = 64)
    private String productNameGift;

    /**
     * 本品赠品
     */
    @CrmColumn(name = "current_product", length = 64)
    private String currentProduct;

    /**
     * 单品起订量类型 字典：products_order_qty_type
     */
    @CrmColumn(name = "product_order_qty_type", length = 64)
    private String productOrderQtyType;

    /**
     * 单品起订量
     */
    @CrmColumn(name = "product_order_qty",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private BigDecimal productOrderQty;


    /**
     * 政策id
     */
    @CrmColumn(name = "promotion_policy_id", length = 64)
    private String promotionPolicyId;

    /**
     * 政策code
     */
    @CrmColumn(name = "promotion_policy_code", length = 64)
    private String promotionPolicyCode;

    /**
     * 政策名称
     */
    @CrmColumn(name = "promotion_policy_name", length = 64)
    private String promotionPolicyName;

    /**
     * 赠送比例，只有赠品才需要
     */
    @CrmColumn(name = "gift_ratio", note = "赠送比例，只有赠品才需要")
    private BigDecimal giftRatio;
}
