package com.biz.crm.promotion.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * 政策规则
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_promotion_policy_rule")
@CrmTable(name = "dms_promotion_policy_rule")
public class PromotionPolicyRuleEntity extends CrmBaseEntity<PromotionPolicyRuleEntity> {

    /**
     * 促销规则id
     */
    @CrmColumn(name = "promotion_rule_id", length = 64)
    private String promotionRuleId;


    /**
     * 规则编码
     */
    @CrmColumn(name = "rule_code", length = 64)
    private String ruleCode;

    /**
     * 规则类型 字典：promotion_policy_rule_type
     */
    @CrmColumn(name = "rule_type", length = 64)
    private String ruleType;

    /**
     * 促销类型 字典：promotion_type
     */
    @CrmColumn(name = "promotion_type", length = 64)
    private String promotionType;

    /**
     * 模板id
     */
    @CrmColumn(name = "promotion_policy_template_id", length = 64)
    private String promotionPolicyTemplateId;

    /**
     * 模板Code
     */
    @CrmColumn(name = "promotion_policy_template_code", length = 64)
    private String promotionPolicyTemplateCode;

    /**
     * 政策id
     */
    @CrmColumn(name = "promotion_policy_id", length = 64)
    private String promotionPolicyId;

    /**
     * 政策code
     */
    @CrmColumn(name = "promotion_policy_code", length = 64)
    private String promotionPolicyCode;

    /**
     * 函数参数体
     */
    @CrmColumn(name = "params",mysqlType = "text",oracleType = "BLOB")
    private String params;

    /**
     * 规则名称
     */
    @CrmColumn(name = "rule_name", length = 100)
    private String ruleName;

}
