package com.biz.crm.promotion.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * 促销范围
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_promotion_policy_scope")
@CrmTable(name = "dms_promotion_policy_scope")
public class PromotionPolicyScopeEntity extends CrmBaseEntity<PromotionPolicyScopeEntity> {

    /**
     * 范围类型 字典：promotion_policy_scope_type
     */
    @CrmColumn(name = "scope_type", length = 64)
    private String scopeType;


    /**
     * 范围名称
     */
    @CrmColumn(name = "scope_name", length = 64)
    private String scopeName;

    /**
     * 范围编码
     */
    @CrmColumn(name = "scope_code", length = 64)
    private String scopeCode;

    /**
     * 是否包含 字典：yesOrNo
     */
    @CrmColumn(name = "containable", length = 64)
    private String containable;

    /**
     * 政策id
     */
    @CrmColumn(name = "promotion_policy_id", length = 64)
    private String promotionPolicyId;

    /**
     * 政策code
     */
    @CrmColumn(name = "promotion_policy_code", length = 64)
    private String promotionPolicyCode;

    /**
     * 政策名称
     */
    @CrmColumn(name = "promotion_policy_name", length = 64)
    private String promotionPolicyName;
}
