package com.biz.crm.promotion.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;


/**
 * 促销规则
 *  @author: luoqi
 *  @Date: 2020-10-15 14:56
 *  @version: V1.0
 *  @Description:
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_promotion_rule")
@CrmTable(name = "dms_promotion_rule")
public class PromotionRuleEntity extends CrmBaseEntity<PromotionRuleEntity> {

    /**
     * 规则名称
     */
    @CrmColumn(name = "rule_name", length = 64)
    private String ruleName;

    /**
     * 规则编码
     */
    @CrmColumn(name = "rule_code", length = 64)
    private String ruleCode;

    /**
     * 规则类型 字典：promotion_policy_rule_type
     */
    @CrmColumn(name = "rule_type", length = 64)
    private String ruleType;

    /**
     * 促销类型 字典：promotion_type
     */
    @CrmColumn(name = "promotion_type", length = 64)
    private String promotionType;

    /**
     * 优先级-用于控制限量规则执行逻辑
     */
    @CrmColumn(name = "level_no",mysqlType = "decimal(16,6)",oracleType = "NUMBER(16, 6)")
    private Integer levelNo;

    /**
     * 函数体
     */
    @CrmColumn(name = "func_body",mysqlType = "text",oracleType = "BLOB")
    private String funcBody;


    /**
     * 调试参数(k-v)
     */
    @CrmColumn(name = "test_param",mysqlType = "text",oracleType = "BLOB")
    private String testParam;


}
