package com.biz.crm.promotion.enums;

import com.biz.crm.eunm.dms.ScopeTypeDynamicEnum;
import com.biz.crm.promotion.service.npromotion.beans.filters.scopefilters.CusScopeFilterImpl;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Getter;
import lombok.SneakyThrows;

/**
 * 账户类型动态枚举，一般包含客户类型和终端类型
 * @Author: chenrong
 * @Date: 2021/4/21 14:52
 */
@Getter
public class AccountTypeDynamicEnum {

  //促销政策账户类型枚举
  private static final String PROMOTION_ACCOUNT_TYPE_DICT_CODE = "dms_promotion_scope_host_type";

  //经销商-枚举
  public static final AccountTypeDynamicEnum CUSTOMER = initEnum("customer", "经销商", CusScopeFilterImpl.class,
          ScopeTypeDynamicEnum.CUS, ScopeTypeDynamicEnum.CUS_ORG, ScopeTypeDynamicEnum.CUS_CHANNEL);
  //终端-枚举
  public static final AccountTypeDynamicEnum TERMINAL = initEnum("terminal", "终端", null,
          ScopeTypeDynamicEnum.TERMINAL, ScopeTypeDynamicEnum.TERMINAL_ORG);

  //编码，必须与相关字典中的编码保持一致
  private String code;
  //描述
  private String desc;
  //范围筛选bean对象
  private Class filerBeanCls;
  //对应的范围类型
  private ScopeTypeDynamicEnum[] scopeTypes;


  /**
   * 初始化静态枚举
   * @param code
   * @param desc
   * @return
   */
  private static AccountTypeDynamicEnum initEnum(String code, String desc, Class filerBeanCls, ScopeTypeDynamicEnum... scopeTypes) {
    return new AccountTypeDynamicEnum(code, desc, filerBeanCls, scopeTypes);
  }


  /**
   * 获取字典中所有的类型，以枚举的类型返回
   * @return
   */
  public static List<AccountTypeDynamicEnum> getAccountTypeEnums() {
    Map<String, String> dictMap = DictUtil.dictMap(PROMOTION_ACCOUNT_TYPE_DICT_CODE);
    if(!CollectionUtil.mapNotEmpty(dictMap)) {
      return Lists.newArrayList();
    }
    List<AccountTypeDynamicEnum> accountTypeDynamicEnums = Lists.newArrayList();
    List<AccountTypeDynamicEnum> staticList = getAllStaticEnums();
    Map<String, AccountTypeDynamicEnum> staticMap = staticList.stream()
            .collect(Collectors.toMap(AccountTypeDynamicEnum::getCode, a -> a));
    dictMap.forEach((k, v) -> {
      if(staticMap.get(k) != null) {
        accountTypeDynamicEnums.add(staticMap.get(k));
      } else {
        AccountTypeDynamicEnum accountTypeDynamicEnum = new AccountTypeDynamicEnum(k, v, null);
        accountTypeDynamicEnums.add(accountTypeDynamicEnum);
      }
    });
    return accountTypeDynamicEnums;
  }

  /**
   * 根据字典编码获取枚举
   * @param code
   * @return
   */
  public static AccountTypeDynamicEnum getAccountTypeEnumsByCode(String code) {
    if(StringUtils.isEmpty(code)) {
      return null;
    }
    List<AccountTypeDynamicEnum> staticList = getAllStaticEnums();
    Map<String, AccountTypeDynamicEnum> staticMap = staticList.stream()
            .collect(Collectors.toMap(AccountTypeDynamicEnum::getCode, a -> a));
    if(staticMap.get(code) != null) {
      return staticMap.get(code);
    }
    String value = DictUtil.dictValue(PROMOTION_ACCOUNT_TYPE_DICT_CODE, code);
    return new AccountTypeDynamicEnum(code, value, null);
  }

  /**
   * 获取所有静态枚举
   * @return
   */
  @SneakyThrows
  public static List<AccountTypeDynamicEnum> getAllStaticEnums(){
    Class cls = AccountTypeDynamicEnum.class;
    Field[] declaredFields = cls.getDeclaredFields();
    List<AccountTypeDynamicEnum> enums = Lists.newArrayList();
    for(Field f : declaredFields) {
      String modifier = Modifier.toString(f.getModifiers());
      if(Objects.equals(modifier, "public static final")) {
        f.setAccessible(true);
        enums.add((AccountTypeDynamicEnum) f.get(null));
      }
    }
    return enums;
  }

  public AccountTypeDynamicEnum(String code, String desc, Class filerBeanCls, ScopeTypeDynamicEnum... scopeTypes) {
    this.code = code;
    this.desc = desc;
    this.filerBeanCls = filerBeanCls;
    this.scopeTypes = scopeTypes;
  }

}
