package com.biz.crm.promotion.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.promotion.entity.PromotionPolicyEntity;
import com.biz.crm.promotion.entity.resp.PromotionPolicyPageResp;
import org.apache.ibatis.annotations.Param;

import java.util.List;


/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:50
 *  @version: V1.0
 *  @Description:
 */
public interface PromotionPolicyMapper extends BaseMapper<PromotionPolicyEntity> {

    /**
     * 可将字段置空的更新
     *  @author: luoqi
     *  @Date: 2020-10-19 15:50
     *  @version: V1.0
     *  @Description:
     */
    int updateNullValById(@Param("entity") PromotionPolicyEntity entity);
    /**
     * 列表
     * @param page
     * @param vo
     * @return
     */
    List<PromotionPolicyPageResp> findList(Page<PromotionPolicyQueryVo> page, @Param("vo") PromotionPolicyQueryVo vo);

    /**
     * 根据查询条件汇总条数
     * @param actPlanNo 活动行号
     * @param id 需要排除的政策id
     * @return
     */
    Integer countByParam(@Param("actPlanNo") String actPlanNo,@Param("id")String id);

    /**
     * 外部系统分页查询促销政策
     * @param page
     * @param vo
     * @return
     */
    List<PromotionInfoRespVo> findPromotionsByParam(Page<PromotionInfoRespVo> page,@Param("vo") PromotionPolicyQueryVo vo);
}
