package com.biz.crm.promotion.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.promotion.entity.PromotionPolicyScopeEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;


/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:50
 *  @version: V1.0
 *  @Description:
 */
public interface PromotionPolicyScopeMapper extends BaseMapper<PromotionPolicyScopeEntity> {


    /**
     * 查询该政策id列表对应的客户编码
     * @param promotionPolicyIds
     * @return
     */
    List<String> selectCustCodesByPromotionPolicyId(@Param("promotionPolicyIds") List<String> promotionPolicyIds);
    /**
     * 查询该政策id列表对应的渠道编码
     * @param promotionPolicyIds
     * @return
     */
    List<String> selectChannelCodesByPromotionPolicyId(@Param("promotionPolicyIds") List<String> promotionPolicyIds);
    /**
     * 查询该政策id列表对应的组织编码
     * @param promotionPolicyIds
     * @return
     */
    List<String> selectOrgCodesByPromotionPolicyId(@Param("promotionPolicyIds") List<String> promotionPolicyIds);

}
