package com.biz.crm.promotion.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateVo;

import java.util.List;

/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:42
 *  @version: V1.0
 *  @Description:
 */
public interface PromotionPolicyTemplateService {

    /**
     * 新增或修改模板
     *  @author: luoqi
     *  @Date: 2020-10-17 11:40
     *  @version: V1.0
     *  @Description:
     */
    void addOrUpdate(PromotionPolicyTemplateEditVo vo);

    /**
     * 加载模板编辑页面数据
     *  @author: luoqi
     *  @Date: 2020-10-17 11:47
     *  @version: V1.0
     *  @Description:
     */
    PromotionPolicyTemplateEditVo loadTemplateEditVo(String templateId, String promotionType);


    /**
     * 加载模板信息-政策编辑场景
     *  @author: luoqi
     *  @Date: 2020-10-20 17:21
     *  @version: V1.0
     *  @Description:
     */
    PromotionPolicyTemplateEditVo loadTemplateInfo(String templateId);
    /**
     * 分页
     *  @author: luoqi
     *  @Date: 2020-10-17 11:48
     *  @version: V1.0
     *  @Description:
     */
    PageResult<PromotionPolicyTemplateVo> getPageList(PromotionPolicyTemplateQueryVo vo);

    /**
     * 删除
     *  @author: luoqi
     *  @Date: 2020-10-16 15:46
     *  @version: V1.0
     *  @Description:
     */
    void del(List<String> templateIds);

    /**
     * 启用
     *  @author: luoqi
     *  @Date: 2020-10-16 15:46
     *  @version: V1.0
     *  @Description:
     */
    void enable(List<String> templateIds);

    /**
     * 禁用
     *  @author: luoqi
     *  @Date: 2020-10-16 15:46
     *  @version: V1.0
     *  @Description:
     */
    void disable(List<String> templateIds);

    /**
     * 根据编码查询
     * @param templateCode
     * @return
     */
  PromotionPolicyTemplateVo findByCode(String templateCode);
}
