package com.biz.crm.promotion.service;

import com.biz.crm.common.ShellResult;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyTemplateEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleVo;
import com.biz.crm.promotion.entity.PromotionRuleEntity;

import java.util.List;
import java.util.Set;

/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:42
 *  @version: V1.0
 *  @Description:
 */
public interface PromotionRuleService {
    String addOrUpdate(PromotionRuleEditVo vo);
    
    /**
     * 测试脚本体
     *  @author: luoqi
     *  @Date: 2020-10-17 17:44
     *  @version: V1.0
     *  @Description:
     */
    Object testFunc(PromotionRuleEditVo vo);
    void del(String id);
    List<PromotionRuleVo> getList(PromotionRuleVo vo);
    PromotionRuleEditVo loadEditVoById(String id);
    /**
     * 加载模板规则数据
     *  @author: luoqi
     *  @Date: 2020-10-17 14:23
     *  @version: V1.0
     *  @Description:
     */
    PromotionPolicyTemplateEditVo loadTemplateRuleGroupByRuleType(PromotionPolicyTemplateEditVo templateEditVo, boolean allRule);
    List<PromotionRuleEntity> getListByIds(Set<String> ids);

    /**
     * 根据规则编码查询
     * @param ruleCode
     * @return
     */
    PromotionRuleEditVo findByRuleCode(String ruleCode);

}
