package com.biz.crm.promotion.service.component.filter;


import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.promotion.service.impl.LoadConfigInfoContext;

/**
 * 政策过滤器
 *  @author: luoqi
 *  @Date: 2020-12-28 10:31
 *  @version: V1.0
 *  @Description:
 */
public abstract class AbstractFilter<PromotionPolicy extends PromotionPolicyInfoDataVo, Context extends LoadConfigInfoContext>  implements Filter<PromotionPolicy, Context> {
    //类名
    private final String hitDetailKeyPrefix = this.getClass().getSimpleName() + ".";

    /**
     * 添加命中该政策的明细记录
     * @param promotionPolicy
     * @param key
     * @param value
     */
    protected void addHitDetail(PromotionPolicy promotionPolicy, String key, String value){
        promotionPolicy.addHitDetail(hitDetailKeyPrefix + key, value);
    }
}
