package com.biz.crm.promotion.service.component.filter.impl;

import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.service.component.filter.AbstractFilter;
import com.biz.crm.promotion.service.component.filter.PromotionPolicyUtils;
import com.biz.crm.promotion.service.impl.LoadConfigInfoContext;
import com.biz.crm.util.JsonPropertyUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Map;


/**
 * 组合起定量校验过滤
 *  @author: luoqi
 *  @Date: 2020-12-26 16:25
 *  @version: V1.0
 *  @Description:
 */
@Component("promotionPolicyGroupFilter")
public class PromotionPolicyGroupFilter extends AbstractFilter<PromotionPolicyInfoDataVo, LoadConfigInfoContext> {

    @Override
    public boolean filter(PromotionPolicyInfoDataVo promotionPolicyInfoVo, LoadConfigInfoContext context) {
        //政策配置的本品
        Map<String, PromotionPolicyProductEntity> currentProductY = context.getCurrentProductY().get(promotionPolicyInfoVo.getId());
        //订单购买的商品量明细
        Map<String, Map<String, BigDecimal>> productsOrderBuyMap = context.getProductsOrderBuyMap();
        this.addHitDetail(promotionPolicyInfoVo, "currentProductY", String.valueOf(JsonPropertyUtil.toJsonString(currentProductY)));
        this.addHitDetail(promotionPolicyInfoVo, "productsOrderBuyMap", String.valueOf(JsonPropertyUtil.toJsonString(productsOrderBuyMap)));
        String qtyType = promotionPolicyInfoVo.getProductsOrderQtyType();
        BigDecimal qty = promotionPolicyInfoVo.getProductsOrderQty();

        //政策配置了组合起定量
        if (StringUtils.isNotBlank(qtyType) && null != qty) {
            //政策没有配置本品,通常不会出现这种情况，如果有，就是数据有问题
            if (null == currentProductY) {
                return false;
            }
            BigDecimal sum = BigDecimal.ZERO;
            for (Map.Entry<String, PromotionPolicyProductEntity> entry : currentProductY.entrySet()) {
                String currentProductCode = entry.getKey();//本品商品编码
                if (!productsOrderBuyMap.containsKey(currentProductCode)) {
                    return false;//订单下没有购买该本品，不能享受该政策
                }
                // 订单商品购买量
                BigDecimal orderQty = PromotionPolicyUtils.getOrderQty(qtyType, currentProductCode, context);
                if (null != orderQty) {
                    sum = sum.add(orderQty);
                }
            }
            // 未满足改政策的组合起定量，过滤掉
            if (qty.compareTo(sum) > 0) {
                return false;
            }
        }
        return true;
    }


}
