package com.biz.crm.promotion.service.component.filter.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.eunm.dms.PromotionEnum;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.promotion.entity.DmsPromotionPolicyOrderDetailEntity;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.service.IDmsPromotionPolicyOrderDetailService;
import com.biz.crm.promotion.service.component.filter.AbstractFilter;
import com.biz.crm.promotion.service.component.filter.AbstractProductFilter;
import com.biz.crm.promotion.service.component.filter.PromotionPolicyUtils;
import com.biz.crm.promotion.service.impl.LoadConfigInfoContext;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 政策使用量上限校验过滤
 *  @author: luoqi
 *  @Date: 2020-12-26 16:23
 *  @version: V1.0
 *  @Description:
 */
@Component("promotionPolicyUpperFilter")
public class PromotionPolicyUpperFilter extends AbstractProductFilter<PromotionPolicyInfoDataVo, LoadConfigInfoContext> {

    @Resource
    private IDmsPromotionPolicyOrderDetailService iDmsPromotionPolicyOrderDetailService;


    @Override
    public boolean filter(PromotionPolicyInfoDataVo promotionPolicyInfoVo, LoadConfigInfoContext context) {
        this.addHitDetail(promotionPolicyInfoVo, "UsedQtyUpper", String.valueOf(promotionPolicyInfoVo.getUsedQtyUpper()));
        if(null == promotionPolicyInfoVo.getUsedQtyUpper()){
            return true;
        }
        //促销政策正常的消费明细
        List<DmsPromotionPolicyOrderDetailEntity> detailEntityList = this.iDmsPromotionPolicyOrderDetailService.list(Wrappers.lambdaQuery(DmsPromotionPolicyOrderDetailEntity.class)
                .eq(DmsPromotionPolicyOrderDetailEntity :: getPromotionPolicyId, promotionPolicyInfoVo.getId())
                .in(DmsPromotionPolicyOrderDetailEntity :: getPolicyOrderDetailStatus
                        , Lists.newArrayList(PromotionEnum.POLICY_ORDER_DETAIL.commit.getVal(), PromotionEnum.POLICY_ORDER_DETAIL.locked.getVal())));
        this.addHitDetail(promotionPolicyInfoVo, "detailEntityList.size", String.valueOf(detailEntityList.size()));
        //没有消费明细
        if(CollectionUtils.isEmpty(detailEntityList)){
            //上限配置小于等于0
            if(BigDecimal.ZERO.compareTo(promotionPolicyInfoVo.getUsedQtyUpper()) >= 0){
                return false;
            }
        }
        //汇总已使用额度
        BigDecimal usedTotal = detailEntityList.stream().map(v -> {
            if(null == v.getUsedQty()){
                return BigDecimal.ZERO;
            }
            return v.getUsedQty();
        }).reduce(BigDecimal.ZERO, BigDecimal :: add);
        this.addHitDetail(promotionPolicyInfoVo, "usedTotal", String.valueOf(usedTotal));
        promotionPolicyInfoVo.setUsedTotal(usedTotal);
        //已使用额度与上限额度比较
        if(usedTotal.compareTo(promotionPolicyInfoVo.getUsedQtyUpper()) >= 0){
            return false;
        }
        return true;
    }



}
