package com.biz.crm.promotion.service.component.function;

import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.ValidateUtils;

import java.math.BigDecimal;
import java.util.List;


/**
 * 计算规则-抽象
 *  @author: luoqi
 *  @Date: 2020-11-26 20:51
 *  @version: V1.0
 *  @Description:
 */
public abstract class AbstractCalculateRuleFunction<Param extends CalculateRuleParam, Resp extends CalculateRuleResponse> implements RuleFunction<Param, Resp> {


    /**
     * 测试规则
     * 测试 testParam
     *{
     * 	"bizParam" : {
     * 		"productOrderBuy" : [{
     * 				"productBuyNo" : 20,
     * 				"productBuyAmount" : 1000,
     * 				"unitConvertor" : 10
     *           }
     * 		],
     * 		"conditionRuleFunctionBeanName" : "tiaoJianShuLiangShuLiang",
     * 		"ladderList" : [{"text":"本单中本品金额购买满","controlKey":"control_key","controls":[{"key":"buyNo","value":100,"label":null,"description":"请输入本品数量","controlType":"input","selectOptions":[]},{"key":"buyUnit","value":"product_base_unit","label":null,"description":"请选择单位","controlType":"select","selectOptions":[{"key":"product_base_unit","value":"基本单位"},{"key":"material_sale_unit","value":"销售单位"}]},{"key":"giftNo","value":5,"label":"，送赠品","description":"请输入赠品数量","controlType":"input","selectOptions":[]},{"key":"buyUnit","value":"product_base_unit","label":null,"description":"请选择单位","controlType":"select","selectOptions":[{"key":"product_base_unit","value":"基本单位"},{"key":"material_sale_unit","value":"销售单位"}]}]},{"text":"本单中本品金额购买满","controlKey":"control_key","controls":[{"key":"buyNo","value":200,"label":null,"description":"请输入本品数量","controlType":"input","selectOptions":[]},{"key":"buyUnit","value":"product_base_unit","label":null,"description":"请选择单位","controlType":"select","selectOptions":[{"key":"product_base_unit","value":"基本单位"},{"key":"material_sale_unit","value":"销售单位"}]},{"key":"giftNo","value":11,"label":"，送赠品","description":"请输入赠品数量","controlType":"input","selectOptions":[]},{"key":"buyUnit","value":"product_base_unit","label":null,"description":"请选择单位","controlType":"select","selectOptions":[{"key":"product_base_unit","value":"基本单位"},{"key":"material_sale_unit","value":"销售单位"}]}]},{"text":"本单中本品金额购买满","controlKey":"control_key","controls":[{"key":"buyNo","value":300,"label":null,"description":"请输入本品数量","controlType":"input","selectOptions":[]},{"key":"buyUnit","value":"product_base_unit","label":null,"description":"请选择单位","controlType":"select","selectOptions":[{"key":"product_base_unit","value":"基本单位"},{"key":"material_sale_unit","value":"销售单位"}]},{"key":"giftNo","value":17,"label":"，送赠品","description":"请输入赠品数量","controlType":"input","selectOptions":[]},{"key":"buyUnit","value":"product_base_unit","label":null,"description":"请选择单位","controlType":"select","selectOptions":[{"key":"product_base_unit","value":"基本单位"},{"key":"material_sale_unit","value":"销售单位"}]}]},{"text":"本单中本品金额购买满","controlKey":"control_key","controls":[{"key":"buyNo","value":400,"label":null,"description":"请输入本品数量","controlType":"input","selectOptions":[]},{"key":"buyUnit","value":"product_base_unit","label":null,"description":"请选择单位","controlType":"select","selectOptions":[{"key":"product_base_unit","value":"基本单位"},{"key":"material_sale_unit","value":"销售单位"}]},{"key":"giftNo","value":30,"label":"，送赠品","description":"请输入赠品数量","controlType":"input","selectOptions":[]},{"key":"buyUnit","value":"product_base_unit","label":null,"description":"请选择单位","controlType":"select","selectOptions":[{"key":"product_base_unit","value":"基本单位"},{"key":"material_sale_unit","value":"销售单位"}]}]}]
     * 	},
     * 	"controlRow" : {}
     * }
     * @param ruleParam
     * @return
     */
    @Override
    public Resp test(TestRuleParam ruleParam) {
        PromotionRuleEditVo.TestParam testParam = ruleParam.getTestParam();
        ValidateUtils.validate(testParam,"测试参数不能为空!");
        ValidateUtils.validate(testParam.getBizParam(),"测试参数[BizParam]不能为空!");
        Param calculateRuleParam = (Param) new CalculateRuleParam();
        String productOrderBuyStr = JsonPropertyUtil.toJsonString(testParam.getBizParam().get("productOrderBuy"));
        ValidateUtils.validate(productOrderBuyStr,"测试参数[BizParam.productOrderBuy]不能为空!");
        List<RuleExecuteParam.ProductOrderBuy> productOrderBuy = JsonPropertyUtil.toArray(productOrderBuyStr, RuleExecuteParam.ProductOrderBuy.class);
        calculateRuleParam.setProductOrderBuy(productOrderBuy);
        String ladderListStr = JsonPropertyUtil.toJsonString(testParam.getBizParam().get("ladderList"));
        ValidateUtils.validate(ladderListStr,"测试参数[BizParam.ladderList]不能为空!");
        List<PromotionRuleEditVo.ControlRow> ladderList = JsonPropertyUtil.toArray(ladderListStr, PromotionRuleEditVo.ControlRow.class);
        calculateRuleParam.setLadderList(ladderList);
        String conditionRuleFunctionBeanName = testParam.getBizParam().get("conditionRuleFunctionBeanName").toString();
        ValidateUtils.validate(conditionRuleFunctionBeanName,"测试参数[BizParam.conditionRuleFunctionBeanName]不能为空!");
        calculateRuleParam.setConditionRuleFunctionBeanName(conditionRuleFunctionBeanName);
        calculateRuleParam.setRuleCode(ruleParam.getRuleCode());
        return this.apply(calculateRuleParam);
    }

    /**
     * 重新设置订单购买量
     * @param productOrderBuy
     * @param remainder
     * @param ruleFunction
     * @param tempLadder
     */
    protected void buildRemainder(List<RuleExecuteParam.ProductOrderBuy> productOrderBuy, BigDecimal remainder, RuleFunction<ConditionRuleParam, ConditionRuleResponse> ruleFunction) {
        productOrderBuy.forEach(buy -> {
            FieldHandleUtil.initDecimalZero(buy);
            BigDecimal money = buy.getProductBuyAmount();
            BigDecimal qua = buy.getProductBuyNo();
            BigDecimal price = qua.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : money.divide(qua, 6, BigDecimal.ROUND_UP);
            String conditionType = ruleFunction.getConditionType();
            if(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.AMOUNT.getItemCode().equals(conditionType)) {
                buy.setProductBuyAmount(remainder);
                buy.setProductBuyNo(remainder.divide(price, 6, BigDecimal.ROUND_UP));
            } else {
                buy.setProductBuyNo(remainder);
                buy.setProductBuyAmount(remainder.multiply(price));
            }
        });
    }
}
