package com.biz.crm.promotion.service.component.function;

import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.param.LimitedRuleParam;
import com.biz.crm.promotion.service.component.function.param.RuleParam;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.ValidateUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;


/**
 * 限量规则
 *  @author: luoqi
 *  @Date: 2020-12-8 16:30
 *  @version: V1.0
 *  @Description:
 */
public abstract class AbstractLimitedRuleFunction<Param extends LimitedRuleParam> implements RuleFunction<Param, BigDecimal> {


    /**
     * 测试规则
     *{
     *     "bizParam" : {
     *         "limitedConfig":10,
     *         "gift":10
     *        },
     * 	"controlRow" : {}
     * }
     * @param ruleParam
     * @return
     */
    @Override
    public BigDecimal test(TestRuleParam ruleParam) {
        Param limitedRuleParam = (Param) new LimitedRuleParam();
        PromotionRuleEditVo.TestParam testParam = ruleParam.getTestParam();
        ValidateUtils.validate(testParam.getBizParam(),"测试参数[BizParam]不能为空!");
        String limitedConfig = testParam.getBizParam().get("limitedConfig").toString();
        String gift = testParam.getBizParam().get("gift").toString();
        ValidateUtils.validate(limitedConfig,"测试参数[BizParam.limitedConfig]不能为空!");
        ValidateUtils.validate(gift,"测试参数[BizParam.gift]不能为空!");
        limitedRuleParam.setRuleCode(ruleParam.getRuleCode());
        limitedRuleParam.setGift(new BigDecimal(gift));
        limitedRuleParam.setLimitedConfig(new BigDecimal(limitedConfig));
        return this.apply((Param) limitedRuleParam);
    }
}
