package com.biz.crm.promotion.service.component.function.impl.fullgift;

import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.function.AbstractConditionRuleFunction;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.biz.crm.promotion.service.component.resolver.ladder.AbstractConditionRuleLadderResolver;
import com.biz.crm.promotion.service.component.resolver.ladder.LadderResolverHelper;
import com.biz.crm.util.CommonConstant;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

/**
 * 条件规则-金额~金额
 * @Author: chenrong
 * @Date: 2021/2/22 9:48
 */
@Component(ConditionAmountAmount.FUNC_BODY)
public class ConditionAmountAmount extends AbstractConditionRuleFunction<ConditionRuleParam, ConditionRuleResponse> {

  public static final String FUNC_BODY = "conditionAmountAmount";

  @Resource
  private LadderResolverHelper ladderResolverHelper;

  @Override
  public ConditionRuleResponse apply(ConditionRuleParam conditionRuleParam) {
    //获取该规则的阶梯解析器
    AbstractConditionRuleLadderResolver ladderResolver = ladderResolverHelper.getResolverByFuncBody(FUNC_BODY);
    //订单内的商品购买明细
    List<RuleExecuteParam.ProductOrderBuy> productOrderBuy = conditionRuleParam.getProductOrderBuy();
    //总金额
    BigDecimal productBuyAmount = BigDecimal.ZERO;
    //汇总商品的总购买量
    if(null != productOrderBuy){
      for(RuleExecuteParam.ProductOrderBuy v : productOrderBuy){
        productBuyAmount = productBuyAmount.add(v.getProductBuyAmount());
      }
    }
    /**
     * 返回订单购买数量对满赠数量取余结果，计算规则脚本可依据该结果进行灵活的阶梯计算
     */
    ConditionRuleResponse response = this.divideAndRemainder(productBuyAmount, ladderResolver.valueAsProductCurrentY(conditionRuleParam.getLadder()));
    //阶梯赠品赠送量数据类型
    response.setResultDataType(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.AMOUNT.getItemCode());
    //阶梯赠品单位配置
//    String unitType = ladderResolver.unitAsProductCurrentN(conditionRuleParam.getLadder());
//    response.setResultDataUnitType(unitType);
    //阶梯赠品赠送量配置
    response.setGiftValue(ladderResolver.valueAsProductCurrentN(conditionRuleParam.getLadder()));
    return response;
  }

  @Override
  public String getConditionType() {
    return CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.AMOUNT.getItemCode();
  }
}
