package com.biz.crm.promotion.service.component.function.impl.fullreduce;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.function.AbstractCalculateRuleFunction;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.biz.crm.util.CommonConstant;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;

/**
 * 计算规则-阶梯循环满减
 * @Author: chenrong
 * @Date: 2021/3/15 10:28
 */
@Component("calculateLadderLoopReduce")
public class CalculateLadderLoopReduce extends AbstractCalculateRuleFunction<CalculateRuleParam, CalculateRuleResponse> {
  /**
   * 执行规则
   * @param calculateRuleParam
   * @return
   */
  @Override
  public CalculateRuleResponse apply(CalculateRuleParam calculateRuleParam) {
    //条件规则
    RuleFunction<ConditionRuleParam, ConditionRuleResponse> ruleFunction;
    try {
      ruleFunction = SpringApplicationContextUtil
              .getApplicationContext().getBean(calculateRuleParam.getConditionRuleFunctionBeanName(), RuleFunction.class);
    }catch (BeansException e){
      throw new BusinessException("促销政策条件规则[" + calculateRuleParam.getConditionRuleFunctionBeanName() + "]计算失败, 未查找到该规则的计算实例", e);
    }
    //结果类型
    String resultDataType = null, resultDataUnitType = null;
    BigDecimal result = null;
    BigDecimal remainder;
    /**
     * 用户配置的阶梯列表
     * 倒序迭代阶梯列表，因为阶梯的顺序是从小到大的，默认由最大阶梯开始计算
     */
    List<PromotionRuleEditVo.ControlRow> ladderList = calculateRuleParam.getLadderList();
    PromotionRuleEditVo.ControlRow tempLadder = null;
    for(int i = ladderList.size() - 1; i >= 0; i--){
      //阶梯
      tempLadder = ladderList.get(i);
      //组装条件规则计算所需参数
      ConditionRuleParam conditionRuleParam = new ConditionRuleParam();
      conditionRuleParam.setLadder(tempLadder);
      conditionRuleParam.setProductOrderBuy(calculateRuleParam.getProductOrderBuy());
      //条件规则计算
      ConditionRuleResponse conditionRuleResponse = ruleFunction.apply(conditionRuleParam);
      remainder = conditionRuleResponse.getRemainder();

      /**
       * 阶梯循环满减计算规则
       */
      if(conditionRuleResponse.getDivide().compareTo(BigDecimal.ZERO) > 0){
        //当前阶梯计算出来的减量
        BigDecimal computeResult = conditionRuleResponse.getGiftValue() == null ? BigDecimal.ZERO : conditionRuleResponse.getGiftValue();
        //如果当前阶梯没有命中则继续匹配下一阶梯
        if(computeResult == null) {
          continue;
        }
        //结果类型
        resultDataType = conditionRuleResponse.getResultDataType();
        //单位类型
        resultDataUnitType = conditionRuleResponse.getResultDataUnitType();
        result = (result == null ? BigDecimal.ZERO : result).add(computeResult.multiply(conditionRuleResponse.getDivide()));
      }
    }
    CalculateRuleResponse calculateRuleResponse = new CalculateRuleResponse();
    //未匹配到合适的促销政策阶梯
    if(null == result){
      //如果当前政策有阶梯，则会产生匹配阶梯的结果信息
      calculateRuleResponse.setNoLadderMatchMsg("购买量还没有达到政策阶梯起送量!");
      calculateRuleResponse.setLadderUsed(Lists.newArrayList());
      return calculateRuleResponse;
    }
    if(CommonConstant.DMS.PRODUCTS_ORDER_QTY_TYPE.NUMBER.getItemCode().equals(resultDataType)) {
      result = result == null ? result : result.setScale( 0, BigDecimal.ROUND_DOWN );
    }
    //计算结果
    calculateRuleResponse.setResultData(result);
    //计算结果类型 QTY_TYPE number:数量； amount:金额
    calculateRuleResponse.setResultDataType(resultDataType);
    //计算结果单位类型 数据字典：unit_type 枚举类：ProductUnitEnum
    calculateRuleResponse.setResultDataUnitType(resultDataUnitType);
    //命中的阶梯
    calculateRuleResponse.setLadderUsed(Lists.newArrayList(tempLadder));
    return calculateRuleResponse;
  }
}
