package com.biz.crm.promotion.service.component.resolver;


import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;

import java.math.BigDecimal;

/**
 * 条件规则阶梯数据解析器
 *  @author: luoqi
 *  @Date: 2021-1-7 14:13
 *  @version: V1.0
 *  @Description:
 */
public interface ConditionRuleLadderResolver {
    /**
     * 本品配置量
     * @param controlRow
     * @return
     */
    BigDecimal valueAsProductCurrentY(PromotionRuleEditVo.ControlRow controlRow);
    /**
     * 本品单位配置
     * @param controlRow
     * @return
     */
    String unitAsProductCurrentY(PromotionRuleEditVo.ControlRow controlRow);
    /**
     * 赠品配置量
     * @param controlRow
     * @return
     */
    BigDecimal valueAsProductCurrentN(PromotionRuleEditVo.ControlRow controlRow);
    /**
     * 赠品单位配置
     * @param controlRow
     * @return
     */
    String unitAsProductCurrentN(PromotionRuleEditVo.ControlRow controlRow);

    /**
     * 获取控件配置的值
     * @param controlRow
     * @return
     */
    Object controlValue(PromotionRuleEditVo.ControlRow controlRow , int index);

    /**
     * 获取控件配置的值-默认取第一个
     * @param controlRow
     * @return
     */
    Object controlValue(PromotionRuleEditVo.ControlRow controlRow);
}
