package com.biz.crm.promotion.service.component.resolver.ladder;


import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyRuleEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.entity.PromotionRuleEntity;
import com.biz.crm.promotion.mapper.PromotionRuleMapper;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Map;

@Component
public class LadderResolverHelper {
    public static final String LADDER_RESOLVER = "LadderResolver";
    @Resource
    private PromotionRuleMapper promotionRuleMapper;
    @Resource
    private Map<String, AbstractConditionRuleLadderResolver> ladderResolverMap;

    private Map<String, String> ruleIdMapFuncBody = Maps.newHashMap();

    /**
     * 获取改规则的阶梯解析器
     * @param ruleEditVo
     * @return
     */
    public AbstractConditionRuleLadderResolver getResolver(PromotionPolicyRuleEditVo ruleEditVo) {
        String promotionRuleId = ruleEditVo.getPromotionRuleId();
        if(StringUtils.isBlank(promotionRuleId)){
            throw new BusinessException("条件规则ID不能为空");
        }
        if(this.ruleIdMapFuncBody.containsKey(promotionRuleId)){
            AbstractConditionRuleLadderResolver ladderResolver = this.ladderResolverMap.get(this.ruleIdMapFuncBody.get(promotionRuleId) + LADDER_RESOLVER);
            if(null == ladderResolver){
                throw new BusinessException("不存在的阶梯解析器[" + this.ruleIdMapFuncBody.get(promotionRuleId) + "]");
            }
            return ladderResolver;
        }
        PromotionRuleEntity ruleEntity = this.promotionRuleMapper.selectById(promotionRuleId);
        if(null == ruleEntity){
            throw new BusinessException("不存在的条件规则ID[" + promotionRuleId + "]");
        }
        this.ruleIdMapFuncBody.put(ruleEntity.getId(), ruleEntity.getFuncBody());
        return this.getResolverByFuncBody(ruleEntity.getFuncBody());
    }
    /**
     * 获取该规则的阶梯解析器
     *
     * @param funcBody
     * @return
     */
    public AbstractConditionRuleLadderResolver getResolverByFuncBody(String funcBody) {
        AbstractConditionRuleLadderResolver ladderResolver = this.ladderResolverMap.get(funcBody + LADDER_RESOLVER);
        if(null == ladderResolver){
            throw new BusinessException("不存在的阶梯解析器[" + funcBody + "]");
        }
        return ladderResolver;
    }
    /**
     * 本品配置量
     *
     * @param ruleEditVo
     * @return
     */
    public BigDecimal valueAsProductCurrentY(PromotionPolicyRuleEditVo ruleEditVo, PromotionRuleEditVo.ControlRow controlRow) {
        return this.getResolver(ruleEditVo).valueAsProductCurrentY(controlRow);
    }

    /**
     * 本品单位配置
     *
     * @param ruleEditVo
     * @return
     */
    public String unitAsProductCurrentY(PromotionPolicyRuleEditVo ruleEditVo, PromotionRuleEditVo.ControlRow controlRow) {
        return this.getResolver(ruleEditVo).unitAsProductCurrentY(controlRow);
    }

    /**
     * 赠品配置量
     *
     * @param ruleEditVo
     * @return
     */
    public BigDecimal valueAsProductCurrentN(PromotionPolicyRuleEditVo ruleEditVo, PromotionRuleEditVo.ControlRow controlRow) {
        return this.getResolver(ruleEditVo).valueAsProductCurrentN(controlRow);
    }

    /**
     * 赠品单位配置
     *
     * @param ruleEditVo
     * @return
     */
    public String unitAsProductCurrentN(PromotionPolicyRuleEditVo ruleEditVo, PromotionRuleEditVo.ControlRow controlRow) {
        return this.getResolver(ruleEditVo).unitAsProductCurrentN(controlRow);
    }
}
