package com.biz.crm.promotion.service.component.resolver.ladder.fullgift;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.component.function.impl.fullgift.ConditionAmountAmount;
import com.biz.crm.promotion.service.component.resolver.ladder.AbstractConditionRuleLadderResolver;
import com.biz.crm.promotion.service.component.resolver.ladder.LadderResolverHelper;
import org.springframework.stereotype.Component;

/**
 * 金额金额阶梯解析器
 * @Author: chenrong
 * @Date: 2021/2/22 9:58
 */
@Component(ConditionAmountAmount.FUNC_BODY + LadderResolverHelper.LADDER_RESOLVER)
public class ConditionRuleAmountAmountLadderResolver extends AbstractConditionRuleLadderResolver {

  /**
   * 初始化配置
   *
   * @author: luoqi
   * @Date: 2021-1-8 16:44
   * @version: V1.0
   * @Description:
   */
  @Override
  protected Config config() {
    Config config = new Config();
    //阶梯组件个数
    config.setControlSize(2);
    //规则实例名
    config.setFuncBody(ConditionAmountAmount.FUNC_BODY);
    //阶梯控件下标-本品购买量
    config.setValueIndexAsProductCurrentY(0);
//        //阶梯控件下标-本品单位
//        config.setUnitIndexAsProductCurrentY(1);
    //阶梯控件下标-赠品赠送量
    config.setValueIndexAsProductCurrentN(1);
    //阶梯控件下标-赠品赠送单位
//    config.setUnitIndexAsProductCurrentN(2);
    return config;
  }

  @Override
  public String unitAsProductCurrentY(PromotionRuleEditVo.ControlRow controlRow) {
    throw new BusinessException("促销政策规则[" + ConditionAmountAmount.FUNC_BODY + "]无需配置本品单位");
  }
}
