package com.biz.crm.promotion.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAndOrgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.promotion.service.ExcelHandleService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;


/**
 * excel逻辑处理实现类
 * @Author: chenrong
 * @Date: 2021/1/26 10:40
 */
@ConditionalOnMissingBean(name = "excelHandleServiceImpl")
@Service("excelHandleService")
public class ExcelHandleServiceImpl implements ExcelHandleService {

  @Resource
  private ApplicationContext applicationContext;
  @Resource
  private MdmCustomerMsgFeign mdmCustomerMsgFeign;

  @Override
  public void downloadUncludeCusTemplate(HttpServletResponse response) {
    org.springframework.core.io.Resource resource = applicationContext.getResource("classpath:template/unclude_cus_import_template.xlsx");
    try (InputStream inputStream = resource.getInputStream();
         OutputStream outputStream = response.getOutputStream()) {
      response.setContentType("application/vnd..ms-excel");
      response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode( "非包含客户导入模板.xls", "utf-8"));
      byte[] bytes = new byte[1024];
      int len;
      while ((len = inputStream.read(bytes)) != -1) {
        outputStream.write(bytes, 0, len);
      }
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  /**
   * 解析非包含客户excel数据
   * @param request
   * @return
   */
  @Override
  public List<MdmCustomerMsgRespVo> analysisUncludeExcel(HttpServletRequest request) {
    try (InputStream inputStream = request.getInputStream()) {
      String orgCodeStr = request.getParameter("orgs");
      ExcelReaderBuilder excelReaderBuilder = EasyExcel.read(inputStream);
      excelReaderBuilder.autoCloseStream(true);
      excelReaderBuilder.excelType(ExcelTypeEnum.XLSX);
      ExcelReaderSheetBuilder sheet = excelReaderBuilder.sheet(0);
      List<Map<Integer, String>> list = sheet.doReadSync();
      ValidateUtils.notEmpty(list, "excel表格解析异常，请确认数据是否正确");
      List<String> cusList = Lists.newArrayList();
      list.forEach(li -> cusList.add(li.get(0)));
      MdmCustomerAndOrgReqVo mdmCustomerAndOrgReqVo = new MdmCustomerAndOrgReqVo();
      mdmCustomerAndOrgReqVo.setCustomerCodeList(cusList);
      List<MdmCustomerMsgRespVo> listResult = ApiResultUtil.objResult(mdmCustomerMsgFeign.findSubCustomerList(mdmCustomerAndOrgReqVo), true);
      String msg = this.validateCusList(listResult, orgCodeStr);
      ValidateUtils.isTrue(StringUtils.isEmpty(msg), msg);
      return listResult;
    } catch (IOException e) {
      e.printStackTrace();
    }
    return Lists.newArrayList();
  }

  /**
   * 校验导入的客户是否属于指定组织或者其下级组织
   * @param listResult
   * @param orgCodeStr
   * @return
   */
  private String validateCusList(List<MdmCustomerMsgRespVo> listResult, String orgCodeStr) {
    StringBuilder builder = new StringBuilder();
    if(CollectionUtil.listEmpty(listResult)) {
      return new String();
    }
    if(StringUtils.isEmpty(orgCodeStr)) {
      return new String();
    }
    List<String> orgCodeList = Lists.newArrayList(Arrays.asList(orgCodeStr.split(",")));
//    Set<String> orgSet = listResult.stream().collect(Collectors.toMap(MdmCustomerMsgRespVo::getCustomerOrgCode, m -> m, (m1, m2) -> m2)).keySet();
    List<String> allOrgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelf(orgCodeList);
    for(MdmCustomerMsgRespVo cus : listResult) {
      if(StringUtils.isEmpty(cus.getOrgCode())) {
        continue;
      }
      List<String> orgCodes = Lists.newArrayList(Arrays.asList(cus.getOrgCode().split(",")));
      List<String> childrenOrg = OrgUtil.getChildrenOrgCodeListIncludeSelf(orgCodes);
      if(CollectionUtil.listEmpty(childrenOrg)) {
        builder.append(";客户".concat(cus.getCustomerCode()).concat("不正确,不属于任何包含组织及下级组织"));
        continue;
      }
      boolean flag = false;
      for(String org : childrenOrg) {
        if(allOrgCodeList.contains(org)) {
          flag = true;
        }
      }
      if(!flag) {
        builder.append(";客户".concat(cus.getCustomerCode()).concat("不正确,不属于任何包含组织及下级组织"));
      }
    }
    return builder.length()>0 ? builder.substring(1) : new String();
  }

}
