package com.biz.crm.promotion.service.impl;

import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfoQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;


/**
 *  @author: luoqi
 *  @Date: 2020-11-25 15:21
 *  @version: V1.0
 *  @Description:
 */
public class LoadConfigInfoContext {
    public LoadConfigInfoContext(){}
    public LoadConfigInfoContext(PromotionPolicyConfigInfoQueryVo configInfoQueryVo){
        this.configInfoQueryVo = configInfoQueryVo;
        if(null != this.configInfoQueryVo){
            List<PromotionPolicyConfigInfoQueryVo.ProductOrderInfo> orderProductInfos = this.configInfoQueryVo.getOrderProductInfos();
            if(null != orderProductInfos){
                orderProductInfos.forEach(v -> {
                    this.productsOrderBuyMap.put(v.getProductCode(), v.getProductBuyMap());
                });
            }
        }
    }
    // 查询参数
    @Getter
    @Setter
    private PromotionPolicyConfigInfoQueryVo configInfoQueryVo;
    // 商品政策id映射(商品组合计算后最终的政策列表映射)
    private Map<String, Set<String>> productsMapPromotionPolicyIds = Maps.newHashMap();

    /**
     * 计算该组商品是否已经映射该政策
     * @param productsCode
     * @param promotionPolicyId
     * @return
     */
    public boolean isDuplicationPromotionPolicy(String productsCode, String promotionPolicyId){
        if(StringUtils.isBlank(productsCode) || StringUtils.isBlank(productsCode)){
            return true;
        }
        Set<String> promotionPolicyIds = this.productsMapPromotionPolicyIds.get(productsCode);
        if(null == promotionPolicyIds){
            promotionPolicyIds = Sets.newHashSet();
            promotionPolicyIds.add(promotionPolicyId);
            this.productsMapPromotionPolicyIds.put(productsCode, promotionPolicyIds);
            return false;
        }
        if(promotionPolicyIds.contains(promotionPolicyId)){
            return true;
        }
        promotionPolicyIds.add(promotionPolicyId);
        return false;
    }
    // 商品政策映射(以单个商品查询的政策-没做综合过滤)
    @Getter
    private Map<String, List<PromotionPolicyInfoDataVo>> productMapPromotionPolicy = Maps.newHashMap();
    public void putPromotionPolicyInfoVos(String productCode, List<PromotionPolicyInfoDataVo> promotionPolicyInfoVos){
        if(StringUtils.isBlank(productCode)){
            return;
        }
        this.productMapPromotionPolicy.put(productCode, promotionPolicyInfoVos);
        if(CollectionUtils.isEmpty(promotionPolicyInfoVos)){
            return;
        }
        // 收集政策id
        this.promotionPolicyIds.addAll(promotionPolicyInfoVos.stream().map(PromotionPolicyInfoVo :: getId).collect(Collectors.toSet()));
    }
    // 政策id
    @Getter
    @Setter
    private Set<String> promotionPolicyIds = Sets.newHashSet();

    // 订单商品数量/金额， (productCode : <qtyType : 数量/金额>)
    @Getter
    @Setter
    private Map<String, Map<String, BigDecimal>> productsOrderBuyMap = Maps.newHashMap();
    // 政策下的本品列表
    @Getter
    @Setter
    private Map<String, Map<String, PromotionPolicyProductEntity>> currentProductY;
    // 政策下的赠品列表
    @Getter
    private Map<String, Map<String, PromotionPolicyProductEntity>> currentProductN;

    /**
     * 政策下的赠品列表
     * @param currentProductN
     */
    public void addCurrentProductN(Map<String, Map<String, PromotionPolicyProductEntity>> currentProductN){
        if(null == currentProductN){
            return;
        }
        if(null == this.currentProductN){
            this.currentProductN = currentProductN;
            return;
        }
        Set<String> promotionPolicyIds = Sets.newHashSet();

        promotionPolicyIds.addAll(currentProductN.keySet());
        promotionPolicyIds.addAll(this.currentProductN.keySet());
        //合并
        Map<String, Map<String, PromotionPolicyProductEntity>> newData = Maps.newHashMap();

        promotionPolicyIds.forEach((promotionPolicyId) -> {
            Map<String, PromotionPolicyProductEntity> addVal = currentProductN.get(promotionPolicyId);
            Map<String, PromotionPolicyProductEntity> thisVal = this.currentProductN.get(promotionPolicyId);
            Map<String, PromotionPolicyProductEntity> newVal = Maps.newHashMap();
            if(null != thisVal){
                newVal.putAll(thisVal);
            }
            if(null != addVal){
                newVal.putAll(addVal);
            }
            newData.put(promotionPolicyId, newVal);
        });
        this.currentProductN = newData;
    }
    // 全部赠品编码
    @Getter
    private Set<String> currentProductCodesN;
    public void addCurrentProductCodesN(Set<String> currentProductCodesN){
        if(null == currentProductCodesN){
            return;
        }
        if(null == this.currentProductCodesN){
            this.currentProductCodesN = currentProductCodesN;
            return;
        }
        //合并
        this.currentProductCodesN.addAll(currentProductCodesN);
    }
    // 全部赠品详细信息
    @Getter
    @Setter
    private Map<String, MdmProductRespVo> currentProductInfoNMap;

}
