package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.dms.promotion.*;
import com.biz.crm.promotion.entity.PromotionPolicyRuleEntity;
import com.biz.crm.promotion.entity.PromotionRuleEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyRuleMapper;
import com.biz.crm.promotion.service.PromotionPolicyRuleService;
import com.biz.crm.promotion.service.PromotionPolicyTemplateService;
import com.biz.crm.promotion.service.PromotionRuleService;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.JsonPropertyUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;


/**
 *  @author: luoqi
 *  @Date: 2020-10-15 16:50
 *  @version: V1.0
 *  @Description:
 */
@Transactional
@ConditionalOnMissingBean(name = "promotionPolicyRuleServiceExpandImpl")
@Service("promotionPolicyRuleService")
public class PromotionPolicyRuleServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<PromotionPolicyRuleMapper, PromotionPolicyRuleEntity> implements PromotionPolicyRuleService {
    @Resource
    private PromotionRuleService promotionRuleService;
    @Resource
    private PromotionPolicyRuleMapper promotionPolicyRuleMapper;

    @Resource
    private PromotionPolicyTemplateService promotionPolicyTemplateService;

    /**
     * @param editVo
     * @author: luoqi
     * @Date: 2020-10-19 16:28
     * @version: V1.0
     * @Description:
     */
    @Override
    public void refreshRule(PromotionPolicyEditReqVo editVo) {
        //删除旧的促销规则
        if(StringUtils.isNotBlank(editVo.getId())){
            this.doDelByPromotionPolicyIdOrCode(Lists.newArrayList(editVo.getId()), null);
        }
        List<PromotionPolicyRuleEditVo> tempEditVos = editVo.takeAllRules();
        List<PromotionPolicyRuleEntity> newEntitys = Lists.newArrayList();
        if(CollectionUtils.isEmpty(tempEditVos)){
            return;
        }
        Set<String> ruleIds = tempEditVos.stream().map(PromotionPolicyRuleEditVo :: getPromotionRuleId).collect(Collectors.toSet());
        Map<String, PromotionRuleEntity> ruleIdMapEntity = promotionRuleService.getListByIds(ruleIds).stream().collect(Collectors.toMap(PromotionRuleEntity :: getId, v -> v, (r, r2) -> r2));
        Set<String> keys = Sets.newHashSet();
        for(PromotionPolicyRuleEditVo temp : tempEditVos){
            String key = temp.getPromotionPolicyId() + temp.getPromotionRuleId();
            if(keys.contains(key)){
                continue;
            }
            PromotionRuleEntity ruleEntity = ruleIdMapEntity.get(temp.getPromotionRuleId());
            if(null == ruleEntity){
                throw new BusinessException("不存在的规则ID[" + temp.getPromotionRuleId() + "]");
            }
            PromotionPolicyRuleEntity entity = CrmBeanUtil.copy(temp, PromotionPolicyRuleEntity.class);
            entity.setId(null);
            entity.setPromotionPolicyCode(editVo.getPromotionPolicyCode());
            entity.setPromotionPolicyId(editVo.getId());
            entity.setPromotionPolicyTemplateCode(editVo.getTemplateCode());
            entity.setPromotionPolicyTemplateId(editVo.getTemplateId());
            entity.setPromotionType(ruleEntity.getPromotionType());
            entity.setRuleCode(ruleEntity.getRuleCode());
            entity.setRuleType(ruleEntity.getRuleType());
            if(CollectionUtils.isEmpty(temp.getControlRows())){
                entity.setParams("[]");
            }else{
                entity.setParams(JsonPropertyUtil.toJsonString(temp.getControlRows()));
            }
            newEntitys.add(entity);
            keys.add(key);
        }
        this.saveBatch(newEntitys);
    }

    /**
     * 加载政策编辑页面促销规则
     *
     * @param editVo
     * @author: luoqi
     * @Date: 2020-10-20 20:47
     * @version: V1.0
     * @Description:
     */
    @Override
    public void loadListForEditPromotionPolicy(PromotionPolicyEditVo editVo) {
        if(StringUtils.isBlank(editVo.getTemplateId())){
            throw new BusinessException("请选择政策模板");
        }

        Map<String, PromotionPolicyRuleEntity>
                calculate, //计算规则-政策已选
                condition, //条件规则-政策已选
                limited;//限量规则-政策已选
        if(StringUtils.isNotBlank(editVo.getId())){
            QueryWrapper<PromotionPolicyRuleEntity> wrapper = Wrappers.query();
            wrapper.in("promotion_policy_id", editVo.getId());
            Map<String, List<PromotionPolicyRuleEntity>> groupByCurrentProduct = promotionPolicyRuleMapper.selectList(wrapper).stream()
                    .collect(Collectors.groupingBy(PromotionPolicyRuleEntity :: getRuleType));

            List<PromotionPolicyRuleEntity> temp = groupByCurrentProduct.get(CommonConstant.DMS.PromotionPolicyRuleType.CALCULATE.getItemCode());

            if(null == temp){
                calculate = Maps.newHashMap();
            }else{
                calculate = temp.stream().collect(Collectors.toMap(PromotionPolicyRuleEntity :: getPromotionRuleId, v -> v, (t, t2) -> t2));
            }

            temp = groupByCurrentProduct.get(CommonConstant.DMS.PromotionPolicyRuleType.CONDITION.getItemCode());
            if(null == temp){
                condition = Maps.newHashMap();
            }else{
                condition = temp.stream().collect(Collectors.toMap(PromotionPolicyRuleEntity :: getPromotionRuleId, v -> v, (t, t2) -> t2));
            }

            temp = groupByCurrentProduct.get(CommonConstant.DMS.PromotionPolicyRuleType.LIMITED.getItemCode());
            if(null == temp){
                limited = Maps.newHashMap();
            }else{
                limited = temp.stream().collect(Collectors.toMap(PromotionPolicyRuleEntity :: getPromotionRuleId, v -> v, (t, t2) -> t2));
            }
        }else{
            calculate = Maps.newHashMap();
            condition = calculate;
            limited = calculate;
        }

        // 促销模板-模板规则配置
        PromotionPolicyTemplateEditVo promotionPolicyTemplateEditVo = promotionPolicyTemplateService.loadTemplateInfo(editVo.getTemplateId());
        editVo.setTemplateEditVo(promotionPolicyTemplateEditVo);
        editVo.setTemplateCode(promotionPolicyTemplateEditVo.getTemplateCode());
        editVo.setTemplateName(promotionPolicyTemplateEditVo.getTemplateName());

        /**
         * 【条件规则-政策已选】与【模板规则配置】计算后的结果
         */
        List<PromotionPolicyRuleEditVo> rulesAsCondition = this.bulidPromotionPolicyRule(promotionPolicyTemplateEditVo.getCondition(), condition, editVo);
        /**
         * 【计算规则-当前政策】与【模板规则配置】计算后的结果
         */
        List<PromotionPolicyRuleEditVo> rulesAsCalculate = this.bulidPromotionPolicyRule(promotionPolicyTemplateEditVo.getCalculate(), calculate, editVo);
        /**
         * 【限量规则-当前政策】与【模板规则配置】计算后的结果
         */
        List<PromotionPolicyRuleEditVo> rulesAsLimited = this.bulidPromotionPolicyRule(promotionPolicyTemplateEditVo.getLimited(), limited, editVo);
        PromotionPolicyRule promotionPolicyRule = new PromotionPolicyRule();
        promotionPolicyRule.setRulesAsCalculate(rulesAsCalculate);
        promotionPolicyRule.setRulesAsCondition(rulesAsCondition);
        promotionPolicyRule.setRulesAsLimited(rulesAsLimited);
        editVo.setPromotionPolicyRule(promotionPolicyRule);

    }

    
    /**
     *  @author: luoqi
     *  @Date: 2020-10-20 22:37
     *  @version: V1.0
     *  @Description:
     */
    private List<PromotionPolicyRuleEditVo> bulidPromotionPolicyRule(List<PromotionRuleSelectionVo> templateRules
            , Map<String, PromotionPolicyRuleEntity> promotionRuleMapId, PromotionPolicyEditVo editVo){
        List<PromotionPolicyRuleEditVo> promotionRulerules = Lists.newArrayList();
        for(PromotionRuleSelectionVo templateRule : templateRules){
            PromotionPolicyRuleEditVo promotionPolicyRuleEditVo;
            List<PromotionRuleEditVo.ControlRow> controlRows = null;
            if(promotionRuleMapId.containsKey(templateRule.getId())){// 当前政策已选中的规则
                PromotionPolicyRuleEntity entity = promotionRuleMapId.get(templateRule.getId());
                promotionPolicyRuleEditVo = CrmBeanUtil.copy(entity, PromotionPolicyRuleEditVo.class);
                controlRows = JsonPropertyUtil.toArray(entity.getParams(), PromotionRuleEditVo.ControlRow.class);
                promotionPolicyRuleEditVo.setSelected(true);
            }else{
                controlRows = Lists.newArrayList();
                promotionPolicyRuleEditVo = CrmBeanUtil.copy(templateRule, PromotionPolicyRuleEditVo.class);
                // 把模板上的控件配置解析成政策控件
                PromotionRuleEditVo.TestParam testParam = JsonPropertyUtil.toObject(templateRule.getTestParam(), PromotionRuleEditVo.TestParam.class);
                if(null != testParam && null != testParam.getControlRow()
                     && !CollectionUtils.isEmpty(testParam.getControlRow().getControls())){
                    PromotionRuleEditVo.ControlRow controlRow = testParam.getControlRow();
                    controlRow.getControls().forEach(v -> {
                        v.setValue(null);//清空模板测试数据
                    });
                    controlRows.add(controlRow);
                }
                promotionPolicyRuleEditVo.setSelected(false);
            }
            promotionPolicyRuleEditVo.setControlRows(controlRows);
            promotionPolicyRuleEditVo.setRuleName(templateRule.getRuleName());
            promotionPolicyRuleEditVo.setPromotionPolicyTemplateId(editVo.getTemplateId());
            promotionPolicyRuleEditVo.setPromotionPolicyTemplateCode(editVo.getTemplateCode());
            promotionPolicyRuleEditVo.setPromotionRuleId(templateRule.getId());

            promotionRulerules.add(promotionPolicyRuleEditVo);
        }
        return promotionRulerules;
    }

    /**
     * 按政策id或政策code 批量删除
     *
     * @param promotionPolicyId
     * @param promotionPolicyCode
     * @author: luoqi
     * @Date: 2020-10-20 16:01
     * @version: V1.0
     * @Description:
     */
    @Override
    public void delByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        this.doDelByPromotionPolicyIdOrCode(promotionPolicyId, promotionPolicyCode);
    }

    @Override
    public List<PromotionPolicyRuleEntity> getRuleByPromotionPolicyIdOrCode(String promotionPolicyId, String promotionPolicyCode) {
        QueryWrapper<PromotionPolicyRuleEntity> wrapper = Wrappers.query();
        if(StringUtils.isNotBlank(promotionPolicyId)){
            wrapper.eq("promotion_policy_id", promotionPolicyId);
        }else if(StringUtils.isNotBlank(promotionPolicyCode)){
            wrapper.eq("promotion_policy_code", promotionPolicyCode);
        }else{
            return Lists.newArrayList();
        }
        return promotionPolicyRuleMapper.selectList(wrapper);
    }

    /**
     * 删除政策下的促销规则
     *  @author: luoqi
     *  @Date: 2020-10-20 11:22
     *  @version: V1.0
     *  @Description:
     */
    private void doDelByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode){
        QueryWrapper<PromotionPolicyRuleEntity> wrapper = Wrappers.query();
        if(!CollectionUtils.isEmpty(promotionPolicyId)){
            wrapper.in("promotion_policy_id", promotionPolicyId);
        }else if(!CollectionUtils.isEmpty(promotionPolicyCode)){
            wrapper.in("promotion_policy_code", promotionPolicyCode);
        }else{
            return;
        }
        promotionPolicyRuleMapper.delete(wrapper);
    }
}
