package com.biz.crm.promotion.service.npromotion;

import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionAvailableResp;
import java.util.List;
import java.util.Map;

/**
 * 促销政策计算（应用）逻辑处理类
 * @Author: chenrong
 * @Date: 2021/4/21 14:39
 */
public interface PromotionComputeService {

  /**
   * 根据客户以及商品（本品）查询可用的所有促销政策
   * @param param
   * @return
   */
  List<PromotionAvailableResp> findAvailablePromotionsByAccount(PromotionQueryReq param);

  /**
   * 根据促销政策编码列表查询促销政策命中情况
   * @param param
   * @return
   */
  List<PromotionEditVo> findHitPromotionsByPromotionCodes(PromotionQueryReq param);

  /**
   * 根据促销政策编码列表查询促销政策命中情况
   * @param params
   * @return
   */
  Map<String, PromotionEditVo> findHitPromotionMapByPromotionCodes(List<PromotionQueryReq> params);

  /**
   * 根据客户查询整单享受促销政策
   * @param param
   * @return
   */
  List<PromotionEditVo> findNoProductPromotionsByAccount(PromotionQueryReq param);

  /**
   * 根据客户查询是否有可用政策
   * @param param
   * @return
   */
  Map<String, Boolean> findAvailablePromotionMapByCus(PromotionQueryReq param);

}
