package com.biz.crm.promotion.service.npromotion;

import com.biz.crm.nebular.dms.npromotion.vo.PromotionScopeVo;
import java.util.List;

/**
 * 促销范围逻辑处理类
 * @Author: chenrong
 * @Date: 2021/4/12 17:04
 */
public interface PromotionScopeService {

  /**
   * 批量保存促销范围
   * 以促销政策编码为单位，数据库中，有则编辑，无则新增
   * @param scopeVos
   * @param promotionPolicyCode
   * @return
   */
  List<PromotionScopeVo> saveBatch(List<PromotionScopeVo> scopeVos, String promotionPolicyCode);

  /**
   * 根据促销政策编码查询促销范围列表
   * @param promotionPolicyCode
   * @return
   */
  List<PromotionScopeVo> findByPromotionCode(String promotionPolicyCode);
}
