package com.biz.crm.promotion.service.npromotion;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionScopeSourceVo;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;

import java.util.List;

/**
 * 促销政策逻辑处理类
 * @Author: chenrong
 * @Date: 2021/4/12 17:02
 */
public interface PromotionService {

  /**
   * 新增促销政策
   * @param createVo
   * @return
   */
  PromotionEditVo create(PromotionEditVo createVo);

  /**
   * 修改促销政策
   * @param updateVo
   * @return
   */
  PromotionEditVo update(PromotionEditVo updateVo);

  /**
   * 根据id查询促销政策详情
   * @param id
   * @return
   */
  PromotionEditVo findDetailsById(String id);

  /**
   * 根据促销编码查需详情
   * @param promotionCode
   * @return
   */
  PromotionEditVo findDetailsByCode(String promotionCode);

  /**
   * 根据促销政策编码查询生效促销政策编码列表
   * @param promotionCodes
   * @return
   */
  List<String> findAvailableByCodes(List<String> promotionCodes);

  /**
   * 通过参数查询促销政策集合(目前需要支持通过促销政策编码集合promotionCodes和是否是查询有效的政策的标识queryEffectiveFlag)
   * @param reqVo
   * @return
   */
  PageResult<PromotionInfoRespVo> findPromotionsByParam(PromotionPolicyQueryVo reqVo);

  /**
   * 分页查询促销范围数据源
   * @param param
   * @return
   */
  PageResult<PromotionScopeSourceVo> findScopeSourcePage(PromotionScopeSourceVo param);

  /**
   * 条件分页查询促销政策
   * @param param
   * @return
   */
  PageResult<PromotionEditVo> findPromotionPageByConditions(PromotionEditVo param);



  /**
   * 提交工作流
   * @param activitiBusinessVo
   * @return
   */
  String submit(ActivitiBusinessVo activitiBusinessVo);

  /**
   * 审批六回调
   * @param activitiCallBackVo
   */
  void callback(ActivitiCallBackVo activitiCallBackVo);

  /**
   * 生成拆分促销政策，如果促销政策商品类型不是本品赠品一一对应，则不做处理
   * @param promotionPolicyCode
   */
  void createSplitPromotion(String promotionPolicyCode);
}
