package com.biz.crm.promotion.service.npromotion.beans;

import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.nebular.dms.npromotion.bo.ConditionParamBo;
import com.biz.crm.nebular.dms.npromotion.bo.ConditionResultBo;
import com.biz.crm.nebular.dms.npromotion.bo.LadderParseBo;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.CollectionUtil;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.COUNT_COUNT;

/**
 * 条件处理抽象类
 * @Author: chenrong
 * @Date: 2021/4/21 15:15
 */
public abstract class AbstractConditionComputer implements RuleFunction<CalculateRuleParam, CalculateRuleResponse> {

  //数量
  public static final String NUMBER = "number";
  //金额
  public static final String AMOUNT = "amount";
  //价格
  public static final String PRICE = "price";
  //比例
  public static final String RATIO = "ratio";

  /**
   * 条件应用抽象方法
   * @param param
   * @return
   */
  public ConditionResultBo conditionApply(ConditionParamBo param) {
    ConditionResultBo conditionResultBo = new ConditionResultBo();
    if(param == null) {
      return conditionResultBo;
    }
    LadderParseBo ladderParseBo = param.getLadderParseBo();
    String sourceType = ladderParseBo.getSourceValueType();
    BigDecimal quantity = BigDecimal.ZERO;
    //源值暂时只支持金额和数量两种类型
    if(AMOUNT.equals(sourceType)) {
      quantity = param.getAmount();
    } else if (NUMBER.equals(sourceType)) {
      quantity = param.getCount();
    }
    //计算阶梯
    this.buildDivide(conditionResultBo, quantity, ladderParseBo);
    return conditionResultBo;
  }

  /**
   * 解析阶梯控件
   * @param ladder
   * @return
   */
  public LadderParseBo parseLadder(PromotionRuleEditVo.ControlRow ladder) {
    List<PromotionRuleEditVo.KeyValParamControl> controls = ladder.getControls();
    //默认，数量-数量
    LadderParseBo ladderParseBo = this.parseLadderByType(controls, COUNT_COUNT.getCode());
    return ladderParseBo;
  }

  /**
   * 根据控件类型解析控件
   * @param controls
   * @param type
   * @return
   */
  protected LadderParseBo parseLadderByType(List<PromotionRuleEditVo.KeyValParamControl> controls, String type) {
    if(CollectionUtil.listEmpty(controls)) {
      return null;
    }
    return PromotionUtil.parseLadderByType(controls, type);
  }

  /**
   * 阶梯匹配，接口传入的值除以阶梯源值
   * @param conditionResultBo
   * @param quantity
   * @param ladderParseBo
   */
  protected void buildDivide(ConditionResultBo conditionResultBo, BigDecimal quantity,LadderParseBo ladderParseBo) {
    if(conditionResultBo == null || quantity == null || ladderParseBo ==null) {
      return;
    }
    //阶梯源值小于或等于0的情况
    if(ladderParseBo.getSourceValue() == null || BigDecimal.ZERO.compareTo(ladderParseBo.getSourceValue()) >= 0) {
      conditionResultBo.setMultiple(BigDecimal.ONE);
      conditionResultBo.setRemainder(BigDecimal.ZERO);
      conditionResultBo.setValue(ladderParseBo.getTargetValue() == null ? BigDecimal.ZERO : ladderParseBo.getTargetValue());
      conditionResultBo.setValueType(ladderParseBo.getTargetValueType());
      conditionResultBo.setUnitType(ladderParseBo.getTargetUnitType());
      return;
    }
    BigDecimal[] remainders = quantity.divideAndRemainder(ladderParseBo.getSourceValue());
    conditionResultBo.setMultiple(remainders[0]);
    conditionResultBo.setRemainder(remainders[1]);
    //如果阶梯一次都匹配不中，则表示阶梯不能命中
    if(conditionResultBo.getMultiple().compareTo(BigDecimal.ZERO) <= 0) {
      return;
    }
    conditionResultBo.setValue(ladderParseBo.getTargetValue() == null ? BigDecimal.ZERO : ladderParseBo.getTargetValue());
    conditionResultBo.setValueType(ladderParseBo.getTargetValueType());
    conditionResultBo.setUnitType(ladderParseBo.getTargetUnitType());
  }





  /****    兼容老版本     *****/
  @Override
  public CalculateRuleResponse apply(CalculateRuleParam p) {
    return new CalculateRuleResponse();
  }
  @Override
  public CalculateRuleResponse test(TestRuleParam testRuleParam) {
    return new CalculateRuleResponse();
  }
}
