package com.biz.crm.promotion.service.npromotion.beans;

import com.biz.crm.nebular.dms.npromotion.bo.LadderParseBo;
import com.biz.crm.nebular.dms.npromotion.bo.LimitedParamBo;
import com.biz.crm.nebular.dms.npromotion.bo.LimitedResultBo;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.TestRuleParam;
import com.biz.crm.promotion.util.PromotionUtil;
import com.biz.crm.util.CollectionUtil;
import java.math.BigDecimal;
import java.util.List;

import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.LIMITED_COUNT;

/**
 * 限量规则计算抽象类
 * @Author: chenrong
 * @Date: 2021/4/22 15:50
 */
public abstract class AbstractLimitedComputer  implements RuleFunction<CalculateRuleParam, CalculateRuleResponse> {

  /**
   * 限量规则匹配
   * @param param
   * @return
   */
  public LimitedResultBo limitedApply(LimitedParamBo param) {
    LimitedResultBo result = new LimitedResultBo();
    if(param == null || CollectionUtil.listEmpty(param.getLadder())) {
      result.setMatchMsg("限量参数参数不合法");
      return result;
    }
    //默认只处理一个阶梯
    LadderParseBo ladderParseBo = this.parseLadder(param.getLadder().get(0));
    BigDecimal value = param.getGiftValue() == null ? BigDecimal.ZERO : param.getGiftValue();
    BigDecimal redisValue = PromotionUtil.getGift(param.getAccountCode(), param.getPromotionCode());
    BigDecimal totalValue = value.add(redisValue);
    BigDecimal targetValue = ladderParseBo.getTargetValue();
    targetValue = targetValue == null ? BigDecimal.ZERO : targetValue;
    boolean flag = targetValue.compareTo(totalValue) > -1;
    BigDecimal availableValue = targetValue.subtract(redisValue);
    result.setMaxGiftValue(availableValue);
    result.setValue(flag);
    result.setRuleCode(param.getRuleCode());
    result.setRuleName(param.getRuleName());
    if(flag) {
      result.setMatchMsg(new String());
    } else {
      availableValue = availableValue.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : availableValue;
      result.setMatchMsg(String.format("限量规则匹配失败，当前赠送数量：%s，历史赠送数量:%s, 可赠送数量：%s", value.toString(), redisValue.toString(), availableValue.toString()));
    }
    return result;
  }

  /**
   * 解析阶梯控件
   * @param ladder
   * @return
   */
  public LadderParseBo parseLadder(PromotionRuleEditVo.ControlRow ladder) {
    List<PromotionRuleEditVo.KeyValParamControl> controls = ladder.getControls();
    //默认，数量
    LadderParseBo ladderParseBo = this.parseLadderByType(controls, LIMITED_COUNT.getCode());
    return ladderParseBo;
  }

  /**
   * 根据控件类型解析控件
   * @param controls
   * @param type
   * @return
   */
  protected LadderParseBo parseLadderByType(List<PromotionRuleEditVo.KeyValParamControl> controls, String type) {
    if(CollectionUtil.listEmpty(controls)) {
      return null;
    }
    return PromotionUtil.parseLadderByType(controls, type);
  }

  /****    兼容老版本     *****/
  @Override
  public CalculateRuleResponse apply(CalculateRuleParam p) {
    return new CalculateRuleResponse();
  }
  @Override
  public CalculateRuleResponse test(TestRuleParam testRuleParam) {
    return new CalculateRuleResponse();
  }

}
