package com.biz.crm.promotion.service.npromotion.beans.condition;

import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.promotion.service.npromotion.beans.AbstractConditionComputer;
import com.biz.crm.nebular.dms.npromotion.bo.ConditionParamBo;
import com.biz.crm.nebular.dms.npromotion.bo.ConditionResultBo;
import com.biz.crm.nebular.dms.npromotion.bo.LadderParseBo;
import java.util.List;
import org.springframework.stereotype.Component;

import static com.biz.crm.eunm.dms.ControlTypeDynamicEnum.COUNT_RATIO;

/**
 * 数量->比例
 * 条件规则实现类
 * @Author: chenrong
 * @Date: 2021/4/23 17:28
 */
@Component(value = "CountRatioCondition")
public class CountRatioCondition extends AbstractConditionComputer {

  /**
   * 条件应用实现方法
   * @param param
   * @return
   */
  @Override
  public ConditionResultBo conditionApply(ConditionParamBo param) {
    return super.conditionApply(param);
  }

  @Override
  public LadderParseBo parseLadder(PromotionRuleEditVo.ControlRow ladder) {
    List<PromotionRuleEditVo.KeyValParamControl> controls = ladder.getControls();
    //金额-金额
    LadderParseBo ladderParseBo = this.parseLadderByType(controls, COUNT_RATIO.getCode());
    return ladderParseBo;
  }
}
