package com.biz.crm.promotion.service.npromotion.beans.filters;

import com.biz.crm.promotion.service.npromotion.beans.AbstractConditionComputer;
import com.biz.crm.promotion.service.npromotion.beans.BaseFilter;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionProductVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionSaleProductVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 起订量过滤抽象类
 * @Author: chenrong
 * @Date: 2021/4/23 16:24
 */
public abstract class AbstractMoqFilter implements BaseFilter {

  public static final String MOQ_MATCH_MSG_OK = "OK";
  public static final String MOQ_MATCH_MSG_ERROR = "ERROR";

  /**
   * 起订量筛选
   * @param promotionEditVo
   * @param saleProductVos
   */
  public abstract String moqApply(PromotionEditVo promotionEditVo, List<PromotionSaleProductVo> saleProductVos);

  /**
   * 每个商品起订量校验
   * @param promotionCurrentProducts
   * @param saleProductVos
   * @return
   */
  protected String perProductFilter(List<PromotionProductVo> promotionCurrentProducts, List<PromotionSaleProductVo> saleProductVos) {
    if (CollectionUtil.listEmpty(saleProductVos) || CollectionUtil.listEmpty(promotionCurrentProducts)) {
      return MOQ_MATCH_MSG_ERROR;
    }
    String msg = new String();
//    Map<String, PromotionProductVo> promotionProductMap = promotionCurrentProducts.stream().collect(
//            Collectors.toMap(PromotionProductVo::getProductCode, a -> a, (a, b) -> a)
//    );
    Map<String, PromotionSaleProductVo> buyProductMap = saleProductVos.stream().collect(
            Collectors.toMap(PromotionSaleProductVo::getProductCode, a -> a, (a, b) -> a)
    );
    for (int i = 0; i < promotionCurrentProducts.size(); i++) {
      PromotionProductVo promotionProductVo = promotionCurrentProducts.get(i);
      PromotionSaleProductVo buyProductVo = buyProductMap.get(promotionProductVo.getProductCode());
      if(buyProductVo == null) {
        buyProductVo = new PromotionSaleProductVo();
      }
      BigDecimal buyQuantity = Objects.equals(AbstractConditionComputer.AMOUNT, promotionProductVo.getProductOrderQtyType()) ?
              buyProductVo.getBuyAmount() : buyProductVo.getBuyCount();
      buyQuantity = buyQuantity == null ? BigDecimal.ZERO : buyQuantity;
      if(buyQuantity.compareTo(promotionProductVo.getProductOrderQty() == null ? BigDecimal.ZERO : promotionProductVo.getProductOrderQty()) < 0) {
        msg = String.join(",", msg, String.format("本品【%s】购买量未满足政策起订量", promotionProductVo.getProductName()));
      }
    }
    if(StringUtils.isEmpty(msg)) {
      msg = MOQ_MATCH_MSG_OK;
    }
    return msg;
  }

  /**
   * 组合商品起订量校验
   *
   * @param composeState
   * @param quantity
   * @param quantityType
   * @param promotionCurrentProducts
   * @param saleProductVos
   * @return
   */
  protected String composeProductFilter(boolean composeState, BigDecimal quantity, String quantityType, List<PromotionProductVo> promotionCurrentProducts, List<PromotionSaleProductVo> saleProductVos) {
    //如果不需要组合校验，则默认校验通过
    if(!composeState) {
      return MOQ_MATCH_MSG_OK;
    }
    Map<String, List<PromotionSaleProductVo>> saleProductsMap = saleProductVos.stream().collect(Collectors.groupingBy(PromotionSaleProductVo::getProductCode));
    BigDecimal buyQuantity = BigDecimal.ZERO;
    for (PromotionProductVo productVo : promotionCurrentProducts) {
      BigDecimal productQuantity = this.getBuyQuantity(quantityType, saleProductsMap, productVo);
      buyQuantity = buyQuantity.add(productQuantity == null ? BigDecimal.ZERO : productQuantity);
    }
    //组合起订量校验
    boolean flag = buyQuantity.compareTo(quantity == null ? BigDecimal.ZERO : quantity) >= 0;
    if(!flag) {
      return "当前政策要求的组合起订量未达到";
    }
    return MOQ_MATCH_MSG_OK;
  }

  /**
   * 获取政策上单个本品的购买量
   * @param quantityType
   * @param saleProductsMap
   * @param productVo
   * @return
   */
  protected BigDecimal getBuyQuantity(String quantityType, Map<String, List<PromotionSaleProductVo>> saleProductsMap, PromotionProductVo productVo) {
    BigDecimal quantity = BigDecimal.ZERO;
    List<PromotionSaleProductVo>  saleProducts = saleProductsMap.get(productVo.getProductCode());
    if(CollectionUtil.listEmpty(saleProducts)) {
      return BigDecimal.ZERO;
    }
    for(PromotionSaleProductVo saleProductVo : saleProducts) {
      quantity = quantity.add(AbstractConditionComputer.AMOUNT.equals(quantityType) ?
              saleProductVo.getBuyAmount() : saleProductVo.getBuyCount());
    }
    return quantity;
  }
}
