package com.biz.crm.promotion.service.npromotion.beans.filters.commonfilters;

import com.biz.crm.promotion.service.npromotion.beans.filters.AbstractCommonFilter;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.util.CollectionUtil;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

/**
 * 政策叠加过滤器
 * 默认在FirstOrderFilterImpl之后创建实例(这个顺序很重要，限量筛选必须放在最后执行)
 * @Author: chenrong
 * @Date: 2021/4/26 10:50
 */
//@Component("ComposeFilterImpl101")
//@ConditionalOnMissingBean(name = "composeFilterExtendImpl101")
public class ComposeFilterImpl extends AbstractCommonFilter {

  /**
   * 政策叠加过滤，默认同种类型均不可叠加(按照编码倒序取第一个)
   * @param promotions
   * @param queryReq
   */
  public List<PromotionEditVo> filter(List<PromotionEditVo> promotions, PromotionQueryReq queryReq) {
    if(CollectionUtil.listEmpty(promotions)) {
      return Lists.newArrayList();
    }
    //根据编码排序
    List<PromotionEditVo> sortedPromotions = promotions.stream()
            .sorted(Comparator.comparing(PromotionEditVo::getPromotionPolicyCode).reversed()).collect(Collectors.toList());
    //排序后的列表根据促销类型分组去重，重复则取第一条
    Map<String, PromotionEditVo> map = sortedPromotions.stream().collect(
            Collectors.toMap(PromotionEditVo::getPromotionType, a -> a, (a, b) -> a));
    //重置传入的政策列表
    promotions.clear();
    promotions.addAll(map.values());
    return promotions;
  }
}
