package com.biz.crm.promotion.service.npromotion.beans.filters.commonfilters;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.PromotionPolicyEunm;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.promotion.service.npromotion.beans.filters.AbstractCommonFilter;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

/**
 * 筛掉商品类型为‘本品赠品一一对应’的促销政策
 * @Author: chenrong
 * @Date: 2021/8/4 11:15
 */
@Component("oneToOneFilterImpl119")
@ConditionalOnMissingBean(name = "oneToOneFilterExtendImpl119")
public class OneToOneFilterImpl extends AbstractCommonFilter {

  /**
   * 筛掉商品类型为‘本品赠品一一对应’的促销政策
   * @param promotions
   * @param queryReq
   */
  public List<PromotionEditVo> filter(List<PromotionEditVo> promotions, PromotionQueryReq queryReq) {
    List<PromotionEditVo> oneToOnePromotions = Lists.newArrayList();
    promotions.forEach(p -> {
      if(p.getTemplateVo() == null) {
        return;
      }
      if(Objects.equals(p.getTemplateVo().getPromotionProduct(),
              PromotionPolicyEunm.PromotionProductTypeEunm.CURRENT_RELATIONAL_GIFT.getCode())
      && Objects.equals(YesNoEnum.YesNoCodeNumberEnum.NO.getCode(), p.getNotShow())){
        oneToOnePromotions.add(p);
      }
    });
    promotions.removeAll(oneToOnePromotions);
    return promotions;
  }
}
