package com.biz.crm.promotion.service.npromotion.beans.filters.productfilters;

import com.biz.crm.promotion.service.npromotion.PromotionProductService;
import com.biz.crm.promotion.service.npromotion.beans.filters.AbstractProductFilter;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionSaleProductVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

/**
 * 商品（本品）筛选
 * @Author: chenrong
 * @Date: 2021/4/21 19:07
 */
@Component
@ConditionalOnMissingBean(name = "productFilterExtendImpl")
public class ProductFilterImpl extends AbstractProductFilter {

  @Resource
  private PromotionProductService promotionProductService;

  /**
   * 商品（本品）筛选
   * @param param
   * @return
   */
  @Override
  public Map<String, List<String>> apply(PromotionQueryReq param) {
    if(param == null || CollectionUtil.listEmpty(param.getSaleProductVos())) {
      return Maps.newHashMap();
    }
    List<PromotionSaleProductVo> saleProductVos = param.getSaleProductVos();
    saleProductVos = saleProductVos.stream().filter(product -> StringUtils.isNotEmpty(product.getProductCode())).collect(Collectors.toList());
    Map<String, List<String>> result = Maps.newHashMap();
    saleProductVos.forEach(product -> {
      List<String> promotionCodes = promotionProductService.findPromotionCodesByProductCode(product.getProductCode());
      result.put(product.getProductCode(), promotionCodes);
    });
    return result;
  }
}
