package com.biz.crm.promotion.service.npromotion.beans.filters.scopefilters;

import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.promotion.enums.AccountTypeDynamicEnum;
import com.biz.crm.eunm.dms.ScopeTypeDynamicEnum;
import com.biz.crm.promotion.service.PromotionPolicyScopeService;
import com.biz.crm.promotion.service.npromotion.PromotionService;
import com.biz.crm.promotion.service.npromotion.beans.filters.AbstractScopeFilter;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.util.OrgUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

/**
 * 客户范围筛选
 * @Author: chenrong
 * @Date: 2021/4/21 15:19
 */
@Component
@ConditionalOnMissingBean(name = "cusScopeFilterExtendImpl")
public class CusScopeFilterImpl extends AbstractScopeFilter {

  @Resource
  private MdmCustomerMsgFeign mdmCustomerMsgFeign;
  @Resource
  private PromotionPolicyScopeService promotionPolicyScopeService;
  @Resource
  private PromotionService promotionService;

  /**
   * 范围筛选
   * @param param
   * @return
   */
  @Override
  public List<String> apply(PromotionQueryReq param) {
    //校验，如果必要参数为空，或者用户类型不匹配当前实现类的性质，则返回不匹配
    if(param == null || StringUtils.isEmpty(param.getAccountType()) || !Objects.equals(param.getAccountType(),
            AccountTypeDynamicEnum.CUSTOMER.getCode()) || StringUtils.isEmpty(param.getAccountCode())){
      return Lists.newArrayList();
    }
    String orgCode;
    //获取组织编码，如果参数没传，则默认为经销商所属组织
    if(StringUtils.isNotEmpty(param.getOrgCode())) {
      orgCode = param.getOrgCode();
    } else {
      MdmCustomerMsgRespVo customerMsg = mdmCustomerMsgFeign.query(null, param.getAccountCode()).getResult();
      orgCode = customerMsg == null ? null : customerMsg.getOrgCode();
    }
    //根据当前组织获取所有下级组织
    List<String> orgCodeList = OrgUtil.getChildrenOrgCodeListIncludeSelf(orgCode);
    //TODO 渠道，待完善
    List<String> channelList = StringUtils.isEmpty(param.getChannelCode()) ? Lists.newArrayList() : Lists.newArrayList(param.getChannelCode());
    //构建根据范围查询可用促销参数
    List<String>[] unitCodes = new List[]{
            Lists.newArrayList(param.getAccountCode()),
            orgCodeList,
            channelList
    };
    ScopeTypeDynamicEnum[] scopeTypes = AccountTypeDynamicEnum.CUSTOMER.getScopeTypes();
    List<String> scopeTypeCodes = Lists.newArrayList();
    for(ScopeTypeDynamicEnum scopeTypeDynamicEnum : scopeTypes) {
      scopeTypeCodes.add(scopeTypeDynamicEnum.getCode());
    }
    //构建根据范围查询可用促销
    List<String> promotionCodes = promotionPolicyScopeService.findPromotionCodesByAccounts(unitCodes, scopeTypeCodes.toArray(new String[scopeTypeCodes.size()]));
    //筛选生效的促销
    List<String> filerPromotionCodes = promotionService.findAvailableByCodes(promotionCodes);
    return filerPromotionCodes;
  }
}
