package com.biz.crm.promotion.service.npromotion.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.promotion.entity.PromotionPolicyScopeEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyScopeMapper;
import com.biz.crm.promotion.service.npromotion.PromotionScopeService;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionScopeVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CommonFieldUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 促销范围逻辑处理实现类
 * @Author: chenrong
 * @Date: 2021/4/13 18:40
 */
@Service
@ConditionalOnMissingBean(name = "promotionScopeServiceExtend")
public class PromotionScopeServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<PromotionPolicyScopeMapper, PromotionPolicyScopeEntity> implements PromotionScopeService {

  @Resource
  private PromotionPolicyScopeMapper promotionPolicyScopeMapper;

  /**
   * 批量保存促销范围
   * 以促销政策编码为单位，数据库中，有则编辑，无则新增
   * @param scopeVos
   * @param promotionPolicyCode
   * @return
   */
  @Override
  @Transactional
  public List<PromotionScopeVo> saveBatch(List<PromotionScopeVo> scopeVos, String promotionPolicyCode) {
    //1、校验入参非空
    if(CollectionUtil.listEmpty(scopeVos)) {
      return Lists.newArrayList();
    }
    //2、查出数据库中已存在的相同的促销政策编码的记录
    List<PromotionScopeVo> dbVos = this.findByPromotionCode(promotionPolicyCode);
    //3、筛选出需要新增的记录列表
    List<PromotionScopeVo> createVos = scopeVos.stream().filter(v -> StringUtils.isEmpty(v.getId())).collect(Collectors.toList());
    List<PromotionPolicyScopeEntity> createEntities = CrmBeanUtil.copyList(createVos, PromotionPolicyScopeEntity.class);
    this.saveBatch(createEntities);
    //替换保存完成后的记录，用于返回结果
    scopeVos.removeAll(createVos);
    scopeVos.addAll(CrmBeanUtil.copyList(createEntities, PromotionScopeVo.class));
    //4、筛选出需要删除的id列表
    List<String> deleteIds = CommonFieldUtil.difference(dbVos, scopeVos, "id");
    this.removeByIds(deleteIds);
    //5、筛选出需要修改的记录列表
    List<PromotionScopeVo> updateVos = scopeVos.stream().filter(v -> StringUtils.isNotEmpty(v.getId()) && !deleteIds.contains(v.getId())).collect(Collectors.toList());
    this.updateBatchById(CrmBeanUtil.copyList(updateVos, PromotionPolicyScopeEntity.class));
    return scopeVos;
  }

  /**
   * 根据促销政策编码查询促销范围列表
   * @param promotionPolicyCode
   * @return
   */
  @Override
  public List<PromotionScopeVo> findByPromotionCode(String promotionPolicyCode) {
    if(StringUtils.isEmpty(promotionPolicyCode)) {
      return Lists.newArrayList();
    }
    List<PromotionPolicyScopeEntity> entities = this.promotionPolicyScopeMapper.selectList(Wrappers
            .<PromotionPolicyScopeEntity>lambdaQuery().eq(PromotionPolicyScopeEntity::getPromotionPolicyCode, promotionPolicyCode));
    return CrmBeanUtil.copyList(entities, PromotionScopeVo.class);
  }
}
