package com.biz.crm.promotion.util;

import com.biz.crm.service.RedisService;
import com.biz.crm.util.CollectionUtil;
import java.util.Collection;
import java.util.List;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

/**
 * redis缓存处理工具类
 * @Author: chenrong
 * @Date: 2021/4/15 15:34
 */
@Component
public class RedisCacheUtil implements ApplicationContextAware {

  private static final int CACHE_MAX_DAYS = 30;

  private static RedisService redisService;
  private static RedisTemplate redisTemplate;

  @Override
  public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    redisService = applicationContext.getBean(RedisService.class);
    redisTemplate = applicationContext.getBean("redisTemplate", RedisTemplate.class);
    PromotionUtil.applicationContext = applicationContext;
  }

  /**
   * 根据key获取缓存对象
   * @param key
   * @return
   */
  protected static<T> T get(String key) {
    T t = (T) redisService.get(key);
    return t;
  }

  /**
   * 根据key列表批量获取缓存对象
   * @param keys
   * @param <T>
   * @return
   */
  protected static<T> List<T> multiGet(List<String> keys) {
    List<T> list = redisTemplate.opsForValue().multiGet(keys);
    return list;
  }

  /**
   * 添加缓存
   * @param key
   * @param value
   */
  protected static void setByDays(String key, Object value) {
    redisService.setDays(key, value, CACHE_MAX_DAYS);
  }

  /**
   * 添加缓存（永不失效）
   * @param key
   * @param value
   */
  protected static void set(String key, Object value) {
    redisService.setDays(key, value, CACHE_MAX_DAYS);
  }

  /**
   * 批量删除缓存
   * @param keys
   */
  protected static void delete(List<String>keys) {
    if(CollectionUtil.listEmpty(keys)) {
      return;
    }
    redisService.del(keys.toArray(new String[keys.size()]));
  }

}
