package com.biz.crm.rotationpic.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.common.PageResult;
import com.biz.crm.companyinformation.entity.CompanyInformationEntity;
import com.biz.crm.crmlog.handle.util.CrmLogSendUtil;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationVo;
import com.biz.crm.nebular.dms.contract.ContractVo;
import com.biz.crm.nebular.dms.rotationpic.DmsRotationPicAreaVo;
import com.biz.crm.nebular.dms.rotationpic.DmsRotationPicVo;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.rotationpic.entity.RotationPicEntity;
import com.biz.crm.rotationpic.mapper.RotationPicMapper;
import com.biz.crm.rotationpic.service.RotationPicAreaService;
import com.biz.crm.rotationpic.service.RotationPicService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/8 17:35
 **/
@ConditionalOnMissingBean(name = "rotationPicServiceExpandImpl")
@Service(value = "rotationPicService")
public class RotationPicServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<RotationPicMapper, RotationPicEntity> implements RotationPicService {


    @Autowired
    private RotationPicMapper rotationPicMapper;

    @Resource
    private RotationPicAreaService rotationPicAreaService;
    @Autowired
    private CrmLogSendUtil crmLogSendUtil;
    /**
     * 1、组装保存主表
     * 2、组装保存区域表
     * @param dmsRotationPicVo
     */
    @Transactional
    @Override
    public void add(DmsRotationPicVo dmsRotationPicVo) {
        //1
        RotationPicEntity entity = new RotationPicEntity();
        BeanUtils.copyProperties(dmsRotationPicVo,entity);
        rotationPicMapper.insert(entity);
        crmLogSendUtil.sendForAdd(ThreadLocalUtil.getObj(GlobalParam.MENU_CODE).toString(), dmsRotationPicVo.getId(),null,dmsRotationPicVo);

        //2
        rotationPicAreaService.replace(dmsRotationPicVo.getAreas(),dmsRotationPicVo.getNoAreas(),entity.getId());
    }

    /**
     * 1、验证
     * 2、组装保存
     * 3、组装保存区域表
     * @param dmsRotationPicVo
     */
    @Transactional
    @Override
    public void edit(DmsRotationPicVo dmsRotationPicVo) {
        //1
        if(StringUtils.isEmpty(dmsRotationPicVo.getId())){
            throw new BusinessException("请指定编辑的图片");
        }
        RotationPicEntity entity = rotationPicMapper.selectById(dmsRotationPicVo.getId());
        if(null == entity){
            throw new BusinessException("编辑的图片不存在或已经被删除!");
        }
        DmsRotationPicVo oldObject = this.findById(dmsRotationPicVo.getId());
        //2
        BeanUtils.copyProperties(dmsRotationPicVo,entity);
        rotationPicMapper.updateById(entity);
        DmsRotationPicVo newObject = this.findById(dmsRotationPicVo.getId());
        crmLogSendUtil.sendForUpdate(ThreadLocalUtil.getObj(GlobalParam.MENU_CODE).toString(), dmsRotationPicVo.getId(),null,oldObject,newObject);

        //3
        rotationPicAreaService.replace(dmsRotationPicVo.getAreas(),dmsRotationPicVo.getNoAreas(),entity.getId());
    }

    @Override
    public DmsRotationPicVo findById(String id) {
        if(StringUtils.isEmpty(id)){
            return null;
        }
        RotationPicEntity entity = rotationPicMapper.selectById(id);
        if(null != entity){
            DmsRotationPicVo vo = new DmsRotationPicVo();
            BeanUtils.copyProperties(entity,vo);
            Map<String,List<DmsRotationPicAreaVo>> areaMap = rotationPicAreaService.findAreaByRotationPicId(entity.getId());
            vo.setAreas(areaMap.get("area"));
            vo.setNoAreas(areaMap.get("noArea"));
            return vo;
        }
        return null;
    }

    @Override
    public PageResult<DmsRotationPicVo> list(DmsRotationPicVo dmsRotationPicVo) {
        QueryWrapper<DmsRotationPicVo> wrapper = Wrappers.<DmsRotationPicVo>query()
                .like(!StringUtils.isEmpty(dmsRotationPicVo.getFileName()), "file_name", dmsRotationPicVo.getFileName())
                .eq(null != dmsRotationPicVo.getSortNum(), "sort_num", dmsRotationPicVo.getSortNum())
                .eq(!StringUtils.isEmpty(dmsRotationPicVo.getEnableStatus()), "enable_status", dmsRotationPicVo.getEnableStatus());
        Page<CusOrgVo> page = PageUtil.buildPage(dmsRotationPicVo.getPageNum(), dmsRotationPicVo.getPageSize());
        List<DmsRotationPicVo> list = rotationPicMapper.list(page,wrapper,dmsRotationPicVo.getSortFiled());
        if(!CollectionUtils.isEmpty(list)){
            Map<String, Map<String,List<DmsRotationPicAreaVo>>> map = rotationPicAreaService.findAreaByRotationPicIds(
                    list.stream().map(DmsRotationPicVo :: getId).collect(Collectors.toList())
            );
            for(DmsRotationPicVo vo : list){
                Map<String,List<DmsRotationPicAreaVo>> areaMap = map.get(vo.getId());
                if(null != areaMap){
                    vo.setAreas(areaMap.get("area"));
                    vo.setNoAreas(areaMap.get("noArea"));
                }
            }
        }
        return PageResult.<DmsRotationPicVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 1、删除轮播图
     * 2、删除轮播图区域
     * @param ids
     */
    @Transactional
    @Override
    public void delByIds(ArrayList<String> ids) {
        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        QueryWrapper<RotationPicEntity> wrapper = Wrappers.<RotationPicEntity>query()
                .in("id", ids);
        List<RotationPicEntity> rotationPicEntities = rotationPicMapper.selectList(wrapper);
        for(RotationPicEntity entity : rotationPicEntities){
            DmsRotationPicVo dmsRotationPicVo = CrmBeanUtil.copy(entity,DmsRotationPicVo.class);
            crmLogSendUtil.sendForDel(ThreadLocalUtil.getObj(GlobalParam.MENU_CODE).toString(),
                    dmsRotationPicVo.getId(),null,dmsRotationPicVo);
        }
        //1
        rotationPicMapper.deleteBatchIds(ids);

        //2
        rotationPicAreaService.delByRotationPicIds(ids);
    }



    /**
     * 1、删除轮播图
     * 2、删除轮播图区域
     * @param dmsRotationPicVo
     */
    @Transactional
    @Override
    public void delByParam(DmsRotationPicVo dmsRotationPicVo) {
        if(null == dmsRotationPicVo){
            throw new BusinessException("请指定查询条件!");
        }
        QueryWrapper<RotationPicEntity> wrapper = Wrappers.<RotationPicEntity>query()
                .like(!StringUtils.isEmpty(dmsRotationPicVo.getFileName()), "file_name", dmsRotationPicVo.getFileName())
                .eq(null != dmsRotationPicVo.getSortNum(), "sort_num", dmsRotationPicVo.getSortNum())
                .eq(!StringUtils.isEmpty(dmsRotationPicVo.getEnableStatus()), "enable_status", dmsRotationPicVo.getEnableStatus());
        List<RotationPicEntity> entities = rotationPicMapper.selectList(wrapper);
        if(!CollectionUtils.isEmpty(entities)){

            for(RotationPicEntity entity : entities){
                crmLogSendUtil.sendForDel(ThreadLocalUtil.getObj(GlobalParam.MENU_CODE).toString(),
                        entity.getId(),null,entity);
            }
            //1
            rotationPicMapper.delete(wrapper);
            //2
            rotationPicAreaService.delByRotationPicIds(
                    entities.stream().map(RotationPicEntity :: getId).collect(Collectors.toList())
            );
        }


    }
}
