package com.biz.crm.rotationpic.util;

import com.biz.crm.nebular.dms.rotationpic.DmsRotationPicAreaVo;
import com.biz.crm.rotationpic.entity.RotationPicAreaEntity;
import com.biz.crm.util.ValidateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/1/26 18:15
 **/
public class RotationPicAreaUtil {


    /**
     * 找出新增的vo列表
     * 1、如果以前没有则全部是新增
     * 2、现在有，以前没有则为新增
     * @param allArea
     * @param entities
     * @return
     */
    public static List<DmsRotationPicAreaVo> filterAddVos(List<DmsRotationPicAreaVo> allArea,List<RotationPicAreaEntity> entities){
        //1
        if(CollectionUtils.isEmpty(entities)){
            return allArea;
        }
        //2
        List<DmsRotationPicAreaVo> reList = new ArrayList<>();
        for(DmsRotationPicAreaVo vo : allArea){
            List<RotationPicAreaEntity> oldEntities =
                    entities.stream().filter(entity -> entity.getOrgCode().equals(vo.getOrgCode())
                            && entity.getContainFlag().intValue() == vo.getContainFlag().intValue()).collect(Collectors.toList());
            if(CollectionUtils.isEmpty(oldEntities)){
                reList.add(vo);
            }
        }
        return reList;
    }

    /**
     * 过滤要删除的id
     * 1、如果没有新增的，则全部删除
     * 2、以前有，现在没有则为删除
     * @param allArea
     * @param entities
     * @return
     */
    public static List<String> filterDelVos(List<DmsRotationPicAreaVo> allArea,List<RotationPicAreaEntity> entities){
        //1
        if(CollectionUtils.isEmpty(allArea)){
            if(CollectionUtils.isEmpty(entities)){
                return new ArrayList<>();
            }
            return entities.stream().map(RotationPicAreaEntity :: getId).collect(Collectors.toList());
        }
        //2
        List<String> reList = new ArrayList<>();
        for(RotationPicAreaEntity entity : entities){
            List<DmsRotationPicAreaVo> oldVos =
                    allArea.stream().filter(vo -> entity.getOrgCode().equals(vo.getOrgCode())
                            && entity.getContainFlag().intValue() == vo.getContainFlag().intValue()).collect(Collectors.toList());
            if(CollectionUtils.isEmpty(oldVos)){
                reList.add(entity.getId());
            }
        }
        return reList;
    }

    /**
     *批量组装实体
     * @param allArea
     * @return
     */
    public static List<RotationPicAreaEntity> packageRntities(List<DmsRotationPicAreaVo> allArea,String rotationPicId){
        if(CollectionUtils.isEmpty(allArea)){
            return new ArrayList<>();
        }
        List<RotationPicAreaEntity> reList = new ArrayList<>(allArea.size());
        for(DmsRotationPicAreaVo vo : allArea){
            RotationPicAreaEntity entity = new RotationPicAreaEntity();
            BeanUtils.copyProperties(vo,entity);
            entity.setRotationPicId(rotationPicId);
            reList.add(entity);
        }
        return reList;
    }

    /**
     * 验证参数确实
     * @param allArea
     */
    public static void validateList(List<DmsRotationPicAreaVo> allArea){
        if(CollectionUtils.isEmpty(allArea)){
            return;
        }
        for(DmsRotationPicAreaVo vo : allArea){
            ValidateUtils.validate(vo.getOrgCode(),"组织编码不能为空");
            ValidateUtils.validate(vo.getOrgName(),"组织名称不能为空");
            ValidateUtils.validate(vo.getContainFlag(),"请确认包含标识");
        }
    }
}
