package com.biz.crm.salecontract.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.salecontract.ContractTemplateVo;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.salecontract.service.ContractTemplateService;
import com.biz.crm.salecontract.service.ContractTupleService;
import com.biz.crm.nebular.dms.salecontract.ContractTupleVo;
import com.biz.crm.salecontract.service.SaleContractService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 管理端-合同接口管理类
 * @Author: chenrong
 * @Date: 2021/2/5 9:54
 */
@Api(value = "管理端-合同接口管理类", tags = "管理端-合同接口管理类")
@RestController
@RequestMapping(value = "/m/saleContract")
public class SaleContractmController {

  @Resource
  private ContractTupleService contractTupleService;
  @Resource
  private SaleContractService saleContractService;
  @Resource
  private ContractTemplateService contractTemplateService;

  @CrmLog
  @ApiOperation(value = "新增合同元组")
  @PostMapping(value = "addTuple")
  public Result<ContractTupleVo> add(@RequestBody ContractTupleVo contractTupleVo) {
    ContractTupleVo result = this.contractTupleService.add(contractTupleVo);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "编辑合同元组")
  @PostMapping(value = "editTuple")
  public Result<ContractTupleVo> edit(@RequestBody ContractTupleVo contractTupleVo) {
    ContractTupleVo result = this.contractTupleService.edit(contractTupleVo);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "条件分页查询合同元组")
  @PostMapping(value = "findTuplePageByConditions")
  public Result<PageResult<ContractTupleVo>> findPageByConditions(@RequestBody ContractTupleVo contractTupleVo) {
    PageResult<ContractTupleVo> result = this.contractTupleService.findPageByConditions(contractTupleVo);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "新增合同")
  @PostMapping("addContract")
  public Result<SaleContractVo> addContract(@RequestBody SaleContractVo saleContractVo) {
    SaleContractVo result = this.saleContractService.add(saleContractVo);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "编辑合同")
  @PostMapping("editContract")
  public Result<SaleContractVo> editContract(@RequestBody SaleContractVo saleContractVo) {
    SaleContractVo result = this.saleContractService.edit(saleContractVo);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "根据编码查询合同详情")
  @GetMapping("findContractDetailByCode")
  public Result<SaleContractVo> findContractDetailByCode(@RequestParam @ApiParam("合同编码") String code) {
    SaleContractVo result = this.saleContractService.findDetailByCode(code);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "条件分页查询合同列表")
  @PostMapping("findContractPageByConditions")
  public Result<PageResult<SaleContractVo>> findContractPageByConditions(@RequestBody SaleContractVo saleContractVo) {
    PageResult<SaleContractVo> result = this.saleContractService.findContractPageByConditions(saleContractVo);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "新增模板")
  @PostMapping("addTemplate")
  public Result<ContractTemplateVo> addTemplate(@RequestBody ContractTemplateVo contractTemplateVo){
    ContractTemplateVo result = this.contractTemplateService.add(contractTemplateVo);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "编辑模板")
  @PostMapping("editTemplate")
  public Result<ContractTemplateVo> editTemplate(@RequestBody ContractTemplateVo contractTemplateVo){
    ContractTemplateVo result = this.contractTemplateService.edit(contractTemplateVo);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "条件分页查询模板")
  @PostMapping("findTemplatePageByConditions")
  public Result<PageResult<ContractTemplateVo>> findTemplatePageByConditions(@RequestBody ContractTemplateVo contractTemplateVo){
    PageResult<ContractTemplateVo> result = this.contractTemplateService.findPageByConditions(contractTemplateVo);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "根据编码查询模板详情")
  @GetMapping("findTemplateDetailsByCode")
  public Result<ContractTemplateVo> findTemplateDetailsByCode(String templateCode){
    ContractTemplateVo result = this.contractTemplateService.findDetailsByCode(templateCode);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "根据编码查看合同详情")
  @GetMapping("findContractDetailsByCode")
  public Result<SaleContractVo> findContractDetailsByCode(String contractCode) {
    SaleContractVo result = this.saleContractService.findDetailByCode(contractCode);
    return Result.ok(result);
  }

  @CrmLog
  @ApiOperation(value = "根据编码查询合同元组详情")
  @GetMapping(value = "findTupleDetailsByCode")
  public Result<ContractTupleVo> findTupleDetailsByCode(String tupleCode) {
    ContractTupleVo result = this.contractTupleService.findByCode(tupleCode);
    return Result.ok(result);
  }

  @ApiOperation(value = "启用合同")
  @PostMapping("/enable")
  @CrmLog
  public Result enable(@RequestBody List<String> ids) {
    saleContractService.enableBatch(ids);
    return Result.ok("启用成功");
  }

  @ApiOperation(value = "禁用合同")
  @PostMapping("/disable")
  @CrmLog
  public Result disable(@RequestBody List<String> ids) {
    saleContractService.disableBatch(ids);
    return Result.ok("禁用成功");
  }

  @ApiOperation(value = "启用模板")
  @PostMapping("/enableTemplate")
  @CrmLog
  public Result enableTemplate(@RequestBody List<String> ids) {
    contractTemplateService.enableBatch(ids);
    return Result.ok("启用成功");
  }

  @ApiOperation(value = "禁用模板")
  @PostMapping("/disableTemplate")
  @CrmLog
  public Result disableTemplate(@RequestBody List<String> ids) {
    contractTemplateService.disableBatch(ids);
    return Result.ok("禁用成功");
  }

  @CrmLog
  @ApiOperation(value = "启用元组")
  @PostMapping("/enableTuple")
  public Result enableTuple(@RequestBody List<String> ids) {
    this.contractTupleService.enableBatch(ids);
    return Result.ok("启用成功");
  }

  @CrmLog
  @ApiOperation(value = "禁用元组")
  @PostMapping("/disableTuple")
  public Result disableTuple(@RequestBody List<String> ids) {
    this.contractTupleService.disableBatch(ids);
    return Result.ok("禁用成功");
  }

  @CrmLog
  @ApiOperation(value = "删除元组")
  @PostMapping("/deleteTuple")
  public Result deleteTuple(@RequestBody List<String> ids) {
    this.contractTupleService.deleteBatch(ids);
    return Result.ok("删除成功");
  }

}
