package com.biz.crm.salecontract.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtTenEntity;


import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 合同元组实体
 * @Author: chenrong
 * @Date: 2021/2/5 9:45
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_contract_tuple")
@CrmTable(name = "dms_contract_tuple",tableNote = "合同要素")
public class ContractTupleEntity extends CrmExtTenEntity {

  private static final long serialVersionUID = -8588835699524458444L;

  /**
   * 编码
   */
  @CrmColumn(name = "code", length = 64, unique = true)
  private String code;
  /**
   * 名称
   */
  @CrmColumn(name = "name", length = 100)
  private String name;
  /**
   * 页面编码
   */
  @CrmColumn(name = "page_code", length = 64)
  private String pageCode;
  /**
   * 功能编码
   */
  @CrmColumn(name = "function_code", length = 64)
  private String functionCode;
  /**
   * 前端项目中的相对路径
   */
  @CrmColumn(name = "relative_path", length = 100)
  private String relativePath;
  /**
   * 前端路由路径
   */
  @CrmColumn(name = "router_path", length = 100)
  private String routerPath;
  /**
   * 对象字段名
   */
  @CrmColumn(name = "json_name", length = 64)
  private String jsonName;
  /**
   * 逻辑处理bean（该模块数据保存和查询）名称
   */
  @CrmColumn(name = "bean_name", length = 100)
  private String beanName;
  /**
   * 富文本内容保存字段，主要用于设置合同细则和违约责任等固定数据
   */
  @CrmColumn(name = "context", length = 4000)
  private String context;

}
