package com.biz.crm.salecontract.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmExtEntity;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;



import javax.persistence.Index;


import static com.biz.crm.eunm.YesNoEnum.YesNoCodeNumberEnum.NO;

/**
 * 合同实体
 * @Author: chenrong
 * @Date: 2021/2/5 11:13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("dms_sale_contract")
@CrmTable(name = "dms_sale_contract", indexes = {
        @Index(name = "i_sale_contract_template_code", columnList = "template_code"),
        @Index(name = "i_sale_contract_contract_type", columnList = "contract_type"),
        @Index(name = "index_yearly", columnList = "yearly"),
        @Index(name = "i_sale_contract_cus_code", columnList = "cus_code"),
        @Index(name = "index_channel_code", columnList = "channel_code"),
        @Index(name = "i_sale_contract_org_code", columnList = "org_code")
},tableNote = "合同主数据")
public class SaleContractEntity extends CrmExtEntity {

  private static final long serialVersionUID = -2907621585607605964L;

  /**
   * 合同编码
   */
  @CrmColumn(name = "code", length = 64)
  private String code;
  /**
   * 合同名称
   */
  @CrmColumn(name = "name", length = 100)
  private String name;
  /**
   * 模板编码
   */
  @CrmColumn(name = "template_code", length = 64)
  private String templateCode;
  /**
   * 合同类型
   */
  @CrmColumn(name = "contract_type", length = 64)
  private String contractType;
  /**
   * 合同年度
   */
  @CrmColumn(name = "yearly", length = 4)
  private String yearly;
  /**
   * 客户编码
   */
  @CrmColumn(name = "cus_code", length = 64)
  private String cusCode;
  /**
   * 客户名称
   */
  @CrmColumn(name = "cus_name", length = 100)
  private String cusName;
  /**
   * 渠道类型
   */
  @CrmColumn(name = "channel_code", length = 64)
  private String channelCode;
  /**
   * 渠道名称
   */
  @CrmColumn(name = "channel_name", length = 100)
  private String channelName;
  /**
   * 所属组织编码
   */
  @CrmColumn(name = "org_code", length = 64)
  private String orgCode;
  /**
   * 所属组织名称
   */
  @CrmColumn(name = "org_name", length = 100)
  private String orgName;
  /**
   * 合同开始时间
   */
  @CrmColumn(name = "start_time", length = 20)
  private String startTime;
  /**
   * 合同结束时间
   */
  @CrmColumn(name = "end_time", length = 20)
  private String endTime;
  /**
   * 签约状态{@link YesNoEnum.YesNoCodeNumberEnum}
   */
  private Integer signState = NO.getCode();



  /*******/
  /**
   * 对接人
   */
  @CrmColumn(name = "docking_people", length = 100)
  private String dockingPeople;
  /**
   * 客户法律代表
   */
  @CrmColumn(name = "cus_legal_representative", length = 100)
  private String cusLegalRepresentative;
  /**
   * 客户联系方式
   */
  @CrmColumn(name = "cus_contact", length = 100)
  private String cusContact;
  /**
   * 省编码
   */
  @CrmColumn(name = "province_code", length = 64)
  private String provinceCode;
  /**
   * 省
   */
  @CrmColumn(name = "province", length = 100)
  private String province;
  /**
   * 市编码
   */
  @CrmColumn(name = "city_code", length = 64)
  private String cityCode;
  /**
   * 市
   */
  @CrmColumn(name = "city", length = 100)
  private String city;
  /**
   * 区县编码
   */
  @CrmColumn(name = "district_code", length = 64)
  private String districtCode;
  /**
   * 区县
   */
  @CrmColumn(name = "district", length = 100)
  private String district;
}
