package com.biz.crm.salecontract.service;

import com.biz.crm.nebular.dms.salecontract.ContractTemplateTupleMappingVo;
import com.biz.crm.nebular.dms.salecontract.ContractTupleVo;
import java.util.List;

/**
 * 合同模板元组映射逻辑处理类
 * @Author: chenrong
 * @Date: 2021/2/5 11:51
 */
public interface ContractTemplateTupleMappingService {

  /**
   * 新增/更新模板元组映射
   * @param mappingVos
   * @param templateCode
   * @return
   */
  List<ContractTemplateTupleMappingVo> replace(List<ContractTupleVo> mappingVos, String templateCode);

  /**
   * 根据合同模板编码查询合同元组
   * @param templateCode
   * @return
   */
  List<ContractTupleVo> findTupleByTemplateCode(String templateCode);

  /**
   * 根据模板编码查询模板/元组映射列表
   * @param templateCode
   * @return
   */
  List<ContractTemplateTupleMappingVo> findMappingByTemplateCode(String templateCode);

  /**
   * 根据元组编码查询映射列表
   * @param tupleCode
   * @return
   */
  List<ContractTemplateTupleMappingVo> findByTupleCode(String tupleCode);
}
