package com.biz.crm.salecontract.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.salecontract.ContractTupleVo;
import com.biz.crm.salecontract.service.listener.AbstractContractModelListener;
import java.util.List;

/**
 * 合同元组逻辑处理类
 * @Author: chenrong
 * @Date: 2021/2/5 9:49
 */
public interface ContractTupleService {

  /**
   * 新增一条合同元组
   * @param contractTupleVo
   * @return
   */
  ContractTupleVo add(ContractTupleVo contractTupleVo);

  /**
   * 编辑一条合同元组
   * @param contractTupleVo
   * @return
   */
  ContractTupleVo edit(ContractTupleVo contractTupleVo);

  /**
   * 根据编码查询
   * @param code
   * @return
   */
  ContractTupleVo findByCode(String code);

  /**
   * 分页条件查询合同元组
   * @param contractTupleVo
   * @return
   */
  PageResult<ContractTupleVo> findPageByConditions(ContractTupleVo contractTupleVo);

  /**
   * 获取元组对应bean对象
   * @param beanName
   * @return
   */
  AbstractContractModelListener getTupleBean(String beanName);

  /**
   * 批量启用
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 批量删除
   * @param ids
   */
  void deleteBatch(List<String> ids);

  /**
   * 删除
   * @param id
   */
  void delete(String id);
}
