package com.biz.crm.salecontract.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import java.util.List;

/**
 * 合同逻辑处理类
 * @Author: chenrong
 * @Date: 2021/2/17 14:26
 */
public interface SaleContractService {

  /**
   * 新增合同
   * @param saleContractVo
   * @return
   */
  SaleContractVo add(SaleContractVo saleContractVo);

  /**
   * 编辑合同
   * @param saleContractVo
   * @return
   */
  SaleContractVo edit(SaleContractVo saleContractVo);

  /**
   * 根据合同编码查询详情
   * @param code 合同编码
   * @return
   */
  SaleContractVo findDetailByCode(String code);

  /**
   * 条件分页查询合同
   * @param saleContractVo
   * @return
   */
  PageResult<SaleContractVo> findContractPageByConditions(SaleContractVo saleContractVo);

  /**
   * 批量启用合同
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 批量禁用
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 客户签约
   * @param vo
   * @return
   */
  SaleContractVo sign(SaleContractVo vo);
}
