package com.biz.crm.salecontract.service.listener;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;

/**
 * 合同任务监听器
 * 合同新增、编辑、查询、删除时，调用此接口的相关实现，来达到同步操作各个子模块的目的
 * 默认数据类型是{@link JSONArray}，里面放的是一个或多个{@link JSONObject}
 * 注意：即使合同与该模块是一对一的关系，也应使用JSONArray传递数据
 * @Author: chenrong
 * @Date: 2021/2/5 11:08
 */
public interface AbstractContractModelListener {

  /**
   * 保存
   * @param data         对象数据（列表）
   * @param contractCode 合同编码
   * @param jsonName     数据对象名称，一般情况下不会用到，如果多个模块实现同一个接口，该参数可以做区分使用
   * @param saleContractVo
   * @param indexCode
   * @return
   */
  JSONArray add(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode);

  /**
   * 编辑
   * @param data         对象数据（列表）
   * @param contractCode 合同编码
   * @param jsonName     数据对象名称，一般情况下不会用到，如果多个模块实现同一个接口，该参数可以做区分使用
   * @param saleContractVo
   * @param indexCode
   * @return
   */
  JSONArray edit(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode);

  /**
   * 根据合同查询
   * @param contractCode 合同编码
   * @param jsonName     数据对象名称，一般情况下不会用到，如果多个模块实现同一个接口，该参数可以做区分使用
   * @param indexCode
   * @return
   */
  JSONArray findByContractCode(String contractCode, String jsonName, String indexCode);
}
