package com.biz.crm.salecontract.service.listener.impl;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.contractdetails.service.ContractDetailsService;
import com.biz.crm.nebular.dms.contractdetails.ContractDetailsVo;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.salecontract.service.listener.AbstractContractModelListener;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.ValidateUtils;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import org.springframework.transaction.annotation.Transactional;

/**
 * 合同细则
 * @author HP
 * @title: ContractDetailsListenerServiceImpl
 * @projectName crm
 * @description: TODO
 * @date 2021/2/239:44
 */
@Service("contractDetailsListener")
@ConditionalOnMissingBean(name = "contractDetailsListenerExtend")
public class ContractDetailsListener implements AbstractContractModelListener {
  @Resource
  private ContractDetailsService contractDetailsService;

  /**
   * 新增合同明细记录
   * 1、校验入参
   * 2、保存数据
   * 3、包装返回结果
   * @param data         对象数据（列表）
   * @param contractCode 合同编码
   * @param jsonName     数据对象名称，一般情况下不会用到，如果多个模块实现同一个接口，该参数可以做区分使用
   * @param saleContractVo
   * @param indexCode
   * @return
   */
  @Override
  @Transactional
  public JSONArray add(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
    //1、
    if(CollectionUtil.jsonArrayEmpty(data)) {
      return new JSONArray();
    }
    ValidateUtils.validate(contractCode, "合同编码不能为空");
    ValidateUtils.validate(saleContractVo, "合同不能为空");
    List<ContractDetailsVo> vos = BeanCopyUtil.parseByJSONArray(data, ContractDetailsVo.class);
    //2、
    List<ContractDetailsVo> result = contractDetailsService.addBatch(vos, contractCode);
    //3、
    return BeanCopyUtil.formatJSONArray(result);
  }

  /**
   * 编辑合同细则记录
   * 1、校验入参
   * 2、解析参数
   * 3、调用方法修改
   * 4、包装返回结果
   * @param data           对象数据（列表）
   * @param contractCode   合同编码
   * @param jsonName       数据对象名称，一般情况下不会用到，如果多个模块实现同一个接口，该参数可以做区分使用
   * @param saleContractVo
   * @param indexCode
   * @return
   */
  @Override
  @Transactional
  public JSONArray edit(JSONArray data, String contractCode, String jsonName, SaleContractVo saleContractVo, String indexCode) {
    //1、校验入参
    ValidateUtils.validate(contractCode, "合同编码不能为空");
    ValidateUtils.validate(saleContractVo, "合同不能为空");
    //2、解析参数
    List<ContractDetailsVo> vos = BeanCopyUtil.parseByJSONArray(data, ContractDetailsVo.class);
    //3、调用方法修改
    List<ContractDetailsVo> result = contractDetailsService.editBatch(vos, contractCode);
    //4、包装返回结果
    return BeanCopyUtil.formatJSONArray(result);
  }

  @Override
  public JSONArray findByContractCode(String contractCode, String jsonName, String indexCode) {
    //1、调用服务返回查询结果
    ContractDetailsVo contractDetailsVo = new ContractDetailsVo();
    contractDetailsVo.setSaleContractCode(contractCode);
    ContractDetailsVo result = contractDetailsService.findByContractCode(contractDetailsVo);
    //2、包装结果
    JSONArray jsonArray = new JSONArray();
    jsonArray.add(result);
    return jsonArray;
  }
}
