package com.biz.crm.salecontract.util;

import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.util.ValidateUtils;
import org.apache.commons.lang3.Validate;

/**
 * 合同工具类
 * @Author: chenrong
 * @Date: 2021/2/17 14:49
 */
public class SaleContractUtil {

  /**
   * 校验合同新增参数
   * @param saleContractVo
   */
  public static void validateAdd(SaleContractVo saleContractVo) {
    ValidateUtils.validate(saleContractVo, "合同对象不能为空");
    ValidateUtils.validate(saleContractVo.getName(), "合同名称不能为空");
    ValidateUtils.validate(saleContractVo.getTemplateCode(), "合同模板编码不能为空");
    ValidateUtils.validate(saleContractVo.getData(), "合同数据不能为空");
  }

  /**
   * 校验合同编辑参数
   * @param saleContractVo
   */
  public static void validateEdit(SaleContractVo saleContractVo) {
    validateAdd(saleContractVo);
    ValidateUtils.validate(saleContractVo.getCode(), "合同编码不能为空");
    ValidateUtils.validate(saleContractVo.getId(), "合同id不能为空");
  }
}
