package com.biz.crm.salegoal.service;

import com.biz.crm.nebular.dms.salegoal.SaleGoalItemVo;
import com.biz.crm.nebular.dms.salegoal.SaleGoalVo;
import com.biz.crm.nebular.dms.salestarget.SalesMonthTargetVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/15 16:10
 **/
public interface SaleGoalItemService {

  /**
   * 批量保存月份目标
   * @param saleGoalItemVos
   */
  void addBatch(List<SaleGoalItemVo> saleGoalItemVos);

  /**
   * 更新月份目标
   * @param saleGoalItemVo
   */
  void update(SaleGoalItemVo saleGoalItemVo);


  /**
   * 根据销售年目标id查询销售月份目标详情
   * 注意：
   * 该方法是为管理端查询销售年目标提供的子方法，因为年目标有了，肯定会存在月目标，所以该方法不用做验证
   * @param saleGoalId
   * @return
   */
  SaleGoalItemVo findBySaleGoalId(String saleGoalId);


  /**
   * 根据销售年目标id列表批量查询销售月份目标详情
   * 注意：
   * 该方法是为管理端查询销售年目标提供的子方法，因为年目标有了，肯定会存在月目标，所以该方法不用做验证
   * @param saleGoalIds
   * @return key->销售年目标id value->详情  map.size = salesTargetId.size map永远不为nul
   */
  Map<String, SaleGoalItemVo> findBySaleGoalIds(List<String> saleGoalIds);

  /**
   * 根据销售目标删除明细记录
   * @param goalIds
   */
  void deleteByGoalIds(List<String> goalIds);
}
