package com.biz.crm.salegoal.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.salecontract.SaleContractVo;
import com.biz.crm.nebular.dms.salegoal.SaleGoalVo;
import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/15 16:10
 **/
public interface SaleGoalService {

  /**
   * 批量新增
   * @param saleGoalVos
   */
  List<SaleGoalVo> addBatch(List<SaleGoalVo> saleGoalVos);

  /**
   * 编辑
   * @param saleGoalVo
   */
  void edit(SaleGoalVo saleGoalVo);

  /**
   * 通过id查询对象
   * @param id
   * @return
   */
  SaleGoalVo findById(String id);

  /**
   * 分页搜索
   * @param saleGoalVo
   * @return
   */
  PageResult<SaleGoalVo> list(SaleGoalVo saleGoalVo);

  /**
   * 根据id批量删除或者恢复
   * @param ids
   */
  void delByIds(ArrayList<String> ids);

  /**
   * 根据查询条件批量删除
   * @param saleGoalVo
   */
  void delByParam(SaleGoalVo saleGoalVo);

  /**
   * 根据合同编码跟新销售目标
   * @param saleGoalVos
   * @param contractCode
   * @param indexCode
   * @param saleContractVo
   * @return
   */
  List<SaleGoalVo> replace(List<SaleGoalVo> saleGoalVos, String contractCode, String indexCode, SaleContractVo saleContractVo);

  /**
   * 根据合同编码删除
   * @param contractCode
   */
  void deleteByContractCode(String contractCode);

  /**
   * 根据合同编码查询详情
   * @param contractCode
   * @param indexCode
   * @return
   */
  List<SaleGoalVo> findDetailsByContractCodeAndIndexCode(String contractCode, String indexCode);
}
